/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class TargetLink
implements IHyperlink {
    private final String fText;
    private final Object fTarget;
    private final int fStart;
    private final int fLength;
    private final int fTargetStart;
    private final int fTargetLength;
    private IRegionSelectionService fSelectionService;

    public TargetLink(String text, int srcStart, int srcLength, Object target, int targetStart, int targetLength, IRegionSelectionService selService) {
        this.fText = text;
        this.fStart = srcStart;
        this.fTarget = target;
        this.fLength = srcLength;
        this.fTargetStart = targetStart;
        this.fTargetLength = targetLength;
        this.fSelectionService = selService;
    }

    public IRegion getHyperlinkRegion() {
        return new Region(this.fStart, this.fLength);
    }

    public String getTypeLabel() {
        return this.fTarget.getClass().getName();
    }

    public String getHyperlinkText() {
        return new String(this.fText);
    }

    public void open() {
        if (this.fSelectionService == null) {
            Object editorInput;
            IPath targetPath = (IPath)this.fTarget;
            IEditorDescriptor ed = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(targetPath.lastSegment());
            if (ed == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("No editor defined for target file " + targetPath.toPortableString()));
                return;
            }
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IPath wsLoc = wsRoot.getLocation();
            if (targetPath.isAbsolute() && !wsLoc.isPrefixOf(targetPath)) {
                ExternalStorage storage = new ExternalStorage(targetPath);
                editorInput = new ExternalEditorInput(storage);
            } else {
                IFile file = wsRoot.getFile(wsLoc.isPrefixOf(targetPath) ? targetPath.removeFirstSegments(wsLoc.segmentCount()) : targetPath);
                editorInput = new FileEditorInput(file);
            }
            try {
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, ed.getId());
                this.fSelectionService = editor instanceof IRegionSelectionService ? (IRegionSelectionService)editor : (IRegionSelectionService)editor.getAdapter(IRegionSelectionService.class);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        if (this.fSelectionService != null) {
            this.fSelectionService.selectAndReveal(this.fTargetStart, this.fTargetLength);
        }
    }

    private static final class ExternalStorage
    implements IStorage {
        private final IPath fPath;

        private ExternalStorage(IPath path) {
            this.fPath = path;
        }

        public InputStream getContents() throws CoreException {
            File file = new File(this.fPath.toOSString());
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fnf) {
                return null;
            }
        }

        public IPath getFullPath() {
            return this.fPath;
        }

        public String getName() {
            return this.fPath.lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    private static final class ExternalEditorInput
    implements IStorageEditorInput {
        private final IStorage fStorage;

        private ExternalEditorInput(IStorage storage) {
            this.fStorage = storage;
        }

        public IStorage getStorage() throws CoreException {
            return this.fStorage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.fStorage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

