/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.core.ErrorHandler;

public abstract class LanguageValidator {
    public abstract boolean validate(IFile var1);

    public abstract boolean validate(String var1);

    protected boolean contains(IFile file, String searchString) {
        try {
            DataInputStream is = new DataInputStream(file.getContents());
            byte[] bytes = new byte[is.available()];
            is.readFully(bytes);
            String contents = new String(bytes);
            return contents.indexOf(searchString) != -1;
        }
        catch (CoreException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected boolean hasNature(IProject project, String natureId) {
        try {
            return project.getNature(natureId) != null;
        }
        catch (CoreException e) {
            ErrorHandler.reportError("LanguageValidator Error", e);
            return false;
        }
    }

    protected String[] getNatures(IProject project) {
        try {
            return project.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            ErrorHandler.reportError("LanguageValidator Error", e);
            return new String[0];
        }
    }
}

