/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.ChangeButtonFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class BooleanFieldEditor
extends ChangeButtonFieldEditor {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private int style;
    private Button checkBox = null;
    private static final FontData[] arialFonts = PlatformUI.getWorkbench().getDisplay().getFontList("Arial", true);
    private static FontData[] labelFonts;

    public BooleanFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int style, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
        this.style = style;
        this.createControl(parent);
    }

    public BooleanFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        this(page, tab, service, level, name, labelText, 0, parent);
    }

    protected void doLoad() {
        if (this.getChangeControl() != null) {
            boolean value;
            if (this.preferencesLevel != null) {
                value = this.preferencesService.getBooleanPreference(this.preferencesLevel, this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesLevel;
                this.setInherited(false);
            } else {
                value = this.preferencesService.getBooleanPreference(this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesService.getApplicableLevel(this.getPreferenceName(), this.preferencesLevel);
                this.setInherited(true);
            }
            this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
            this.setBooleanValue(value);
        }
    }

    protected void doLoadDefault() {
        if (this.getChangeControl() != null) {
            boolean value = this.preferencesService.getBooleanPreference("default", this.getPreferenceName());
            this.levelFromWhichLoaded = "default";
            this.setInherited(false);
            this.setPresentsDefaultValue(true);
            this.setBooleanValue(value);
        }
    }

    protected void doLoadLevel(String level) {
        if (this.getChangeControl() != null) {
            boolean value = this.preferencesLevel != null ? this.preferencesService.getBooleanPreference(level, this.getPreferenceName()) : this.preferencesService.getBooleanPreference(this.getPreferenceName());
            this.levelFromWhichLoaded = level;
            this.setInherited(false);
            this.setPresentsDefaultValue("default".equals(level));
            this.setBooleanValue(value);
        }
    }

    protected void refreshValidState() {
        this.notifyState(true);
    }

    protected String doLoadWithInheritance() {
        boolean levelChanged;
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int fieldLevelIndex = this.preferencesService.getIndexForLevel(this.preferencesLevel);
        boolean value = false;
        int levelAtWhichFound = -1;
        IEclipsePreferences[] nodes = this.preferencesService.getNodesForLevels();
        for (int level = fieldLevelIndex; level < levels.length; ++level) {
            String result;
            if (nodes[level] == null || (result = nodes[level].get(this.getPreferenceName(), null)) == null) continue;
            value = nodes[level].getBoolean(this.getPreferenceName(), false);
            levelAtWhichFound = level;
            levelLoaded = levels[levelAtWhichFound];
            break;
        }
        String previousLevelFromWhichLoaded = this.levelFromWhichLoaded;
        this.levelFromWhichLoaded = levelLoaded;
        this.setInherited(fieldLevelIndex != levelAtWhichFound);
        this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
        this.setPreviousBooleanValue(this.getBooleanValue());
        boolean valueChanged = this.previousValue == null || (Boolean)this.previousValue != value;
        boolean bl = levelChanged = previousLevelFromWhichLoaded == null && this.levelFromWhichLoaded != null || previousLevelFromWhichLoaded != null && this.levelFromWhichLoaded == null || previousLevelFromWhichLoaded != null && !previousLevelFromWhichLoaded.equals(this.levelFromWhichLoaded);
        if (levelChanged || valueChanged) {
            this.setBooleanValue(value);
        }
        if (!this.isInherited()) {
            this.getChangeControl().setBackground(PreferencesUtilities.colorWhite);
        } else {
            this.getChangeControl().setBackground(PreferencesUtilities.colorBluish);
        }
        this.setPresentsDefaultValue(levelAtWhichFound == 3);
        return levelLoaded;
    }

    protected void doStore() {
        boolean value = this.getBooleanValue();
        this.preferencesService.setBooleanPreference(this.preferencesLevel, this.getPreferenceName(), value);
        this.fieldModified = false;
        this.getChangeControl().setBackground(PreferencesUtilities.colorWhite);
        IEclipsePreferences node = this.preferencesService.getNodeForLevel(this.preferencesLevel);
        try {
            if (node != null) {
                node.flush();
            }
        }
        catch (BackingStoreException e) {
            System.err.println("SBFE.doStore():  BackingStoreException \t;  node may not have been flushed:\n\tnode path = " + node.absolutePath() + ", preferences level = " + this.preferencesLevel);
        }
    }

    public void setPreferencesLevel(String level) {
        if (!this.preferencesService.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("SafairBooleanFieldEditor.setPreferencesLevel:  given level = " + level + " is invalid");
        }
        if (level.equals("project") && this.preferencesService.getProject() == null) {
            throw new IllegalStateException("SafairBooleanFieldEditor.setPreferenceLevel:  given level is 'project' but project is not defined for preferences service");
        }
        this.preferencesLevel = level;
    }

    public String getPreferencesLevel() {
        return this.preferencesLevel;
    }

    public boolean getBooleanValue() {
        return this.getChangeControl().getSelection();
    }

    protected void setPreviousBooleanValue(boolean value) {
        this.previousValue = value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean getPreviousBooleanValue() {
        return (Boolean)this.previousValue;
    }

    public void setFieldValueFromOutside(boolean newValue) {
        this.setPreviousBooleanValue(this.getBooleanValue());
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.setBooleanValue(newValue);
    }

    protected void setBooleanValue(boolean newValue) {
        Button button = this.getChangeControl();
        if (button != null && !button.isDisposed()) {
            boolean currentValue = this.getBooleanValue();
            if (this.previousValue == null) {
                this.setPreviousBooleanValue(!currentValue);
            }
            button.setSelection(newValue);
            this.fieldModified = true;
            this.valueChanged();
        } else {
            if (button.isDisposed()) {
                throw new IllegalStateException("BooleanFieldEditor.setBooleanValue:  button is disposed");
            }
            if (button == null) {
                throw new IllegalStateException("BooleanFieldEditor.setBooleanValue:  button is null");
            }
        }
    }

    protected boolean valueChanged() {
        boolean newValue;
        boolean changed = false;
        boolean oldValue = this.getPreviousBooleanValue();
        if (oldValue != (newValue = this.getBooleanValue())) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
            changed = true;
        }
        this.setModifiedMarkOnLabel();
        return changed;
    }

    private boolean getLabelFonts() {
        if (labelFonts == null) {
            labelFonts = new FontData[2];
            block4: for (FontData fd : arialFonts) {
                if (fd.getHeight() > 10) continue;
                switch (fd.getStyle()) {
                    case 0: {
                        BooleanFieldEditor.labelFonts[0] = fd;
                        continue block4;
                    }
                    case 2: {
                        BooleanFieldEditor.labelFonts[1] = fd;
                    }
                }
            }
        }
        return labelFonts[0] != null && labelFonts[1] != null;
    }

    public void setModifiedMarkOnLabel() {
        if (this.checkBox != null) {
            this.checkBox.setForeground(PreferencesUtilities.colorRed);
            if (!this.getLabelFonts()) {
                return;
            }
            this.checkBox.setFont(new Font((Device)this.getPage().getShell().getDisplay(), labelFonts[1]));
        }
    }

    public void clearModifiedMarkOnLabel() {
        if (!this.getLabelFonts()) {
            return;
        }
        if (this.checkBox != null) {
            this.checkBox.setForeground(PreferencesUtilities.colorBlack);
            if (!this.getLabelFonts()) {
                return;
            }
            this.checkBox.setFont(new Font((Device)this.getPage().getShell().getDisplay(), labelFonts[0]));
        }
    }

    public Button getChangeControl() {
        if (!this.parent.isDisposed()) {
            if (this.checkBox == null) {
                this.checkBox = new Button(this.parent, 16416);
                this.checkBox.setFont(this.parent.getFont());
                this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BooleanFieldEditor.this.setPreviousBooleanValue(!BooleanFieldEditor.this.getBooleanValue());
                        BooleanFieldEditor.this.fieldModified = true;
                        BooleanFieldEditor.this.setInherited(false);
                        BooleanFieldEditor.this.levelFromWhichLoaded = BooleanFieldEditor.this.preferencesLevel;
                        BooleanFieldEditor.this.setBooleanValue(BooleanFieldEditor.this.getBooleanValue());
                        BooleanFieldEditor.this.setPresentsDefaultValue(false);
                    }
                });
                this.checkBox.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        BooleanFieldEditor.this.checkBox = null;
                    }
                });
            } else {
                this.checkParent((Control)this.checkBox, this.parent);
            }
            return this.checkBox;
        }
        return null;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.style == 1) {
            --numColumns;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        String toolTipText = this.getToolTipText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(parent);
                --numColumns;
                text = null;
            }
        }
        this.checkBox = this.getChangeControl();
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
        if (text != null) {
            this.checkBox.setText(text);
            if (toolTipText != null) {
                this.checkBox.setToolTipText(toolTipText);
            }
        }
    }

    protected void doSetToolTip() {
        if (this.toolTipText != null) {
            this.getChangeControl().setToolTipText(this.toolTipText);
        }
    }

    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }
}

