/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.ChangeButtonFieldEditor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.osgi.service.prefs.BackingStoreException;

public class ColorFieldEditor
extends ChangeButtonFieldEditor {
    public static final RGB COLOR_DEFAULT = new RGB(0, 0, 0);
    public static final String COLOR_DEFAULT_SPEC = StringConverter.asString((RGB)COLOR_DEFAULT);
    private ColorSelector colorSelector;

    public ColorFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.colorSelector.getButton().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        control.setLayoutData((Object)gd);
        Button colorButton = this.getChangeControl(parent);
        colorButton.setLayoutData((Object)new GridData());
    }

    public int getNumberOfControls() {
        return 2;
    }

    public ColorSelector getColorSelector() {
        return this.colorSelector;
    }

    public Button getChangeControl() {
        if (this.colorSelector == null) {
            return null;
        }
        return this.colorSelector.getButton();
    }

    protected Button getChangeControl(Composite parent) {
        if (this.colorSelector == null) {
            this.colorSelector = new ColorSelector(parent);
            this.colorSelector.addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ColorFieldEditor.this.fireValueChanged(event.getProperty(), event.getOldValue(), event.getNewValue());
                    ColorFieldEditor.this.setPresentsDefaultValue(false);
                    ColorFieldEditor.this.setInherited(false);
                    ColorFieldEditor.this.fieldModified = true;
                }
            });
        } else {
            this.checkParent((Control)this.colorSelector.getButton(), parent);
        }
        return this.colorSelector.getButton();
    }

    protected void doSetToolTip() {
        this.getLabelControl().setToolTipText(this.toolTipText);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl(parent).setEnabled(enabled);
    }

    protected void doLoad() {
        if (this.colorSelector == null) {
            return;
        }
        this.updateColor(this.preferencesService.getStringPreference(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        if (this.colorSelector == null) {
            return;
        }
        this.updateColor(this.preferencesService.getStringPreference("default", this.getPreferenceName()));
    }

    protected void doLoadLevel(String level) {
        String colorValue = this.preferencesService.getStringPreference(level, this.getPreferenceName());
        this.updateColor(colorValue);
    }

    private void updateColor(String colorSpec) {
        RGB color = StringConverter.asRGB((String)colorSpec, null);
        if (color == null) {
            color = COLOR_DEFAULT;
        }
        this.colorSelector.setColorValue(color);
    }

    protected String doLoadWithInheritance() {
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int startingLevelIdx = this.preferencesLevel == null ? 0 : PREFS_LEVELS_AS_LIST.indexOf(this.preferencesLevel);
        int levelAtWhichFound = -1;
        String encodedColorValue = null;
        for (int level = startingLevelIdx; level < levels.length; ++level) {
            encodedColorValue = this.preferencesService.getRawStringPreference(levels[level], this.getPreferenceName());
            if (encodedColorValue == null) continue;
            levelAtWhichFound = level;
            levelLoaded = levels[levelAtWhichFound];
            break;
        }
        if (encodedColorValue == null) {
            encodedColorValue = COLOR_DEFAULT_SPEC;
        }
        this.levelFromWhichLoaded = levelLoaded;
        this.setInherited(startingLevelIdx != levelAtWhichFound);
        this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
        this.fieldModified = true;
        this.previousValue = this.colorSelector.getColorValue();
        this.colorSelector.setColorValue(StringConverter.asRGB((String)encodedColorValue));
        this.updateColor(encodedColorValue);
        return levelLoaded;
    }

    protected void doStore() {
        RGB value = this.colorSelector.getColorValue();
        this.preferencesService.setStringPreference(this.preferencesLevel, this.getPreferenceName(), StringConverter.asString((RGB)value));
        this.fieldModified = false;
        this.getLabelControl().setBackground(PreferencesUtilities.colorWhite);
        IEclipsePreferences node = this.preferencesService.getNodeForLevel(this.preferencesLevel);
        try {
            if (node != null) {
                node.flush();
            }
        }
        catch (BackingStoreException e) {
            System.err.println("SCFE.doStore(): BackingStoreException; node may not have been flushed:\n\tnode path = " + node.absolutePath() + ", preferences level = " + this.preferencesLevel);
        }
    }

    public void setFieldValueFromOutside(String newValue) {
        this.previousValue = this.colorSelector.getColorValue();
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.updateColor(newValue);
    }

    protected boolean valueChanged() {
        boolean valueChanged = this.inheritanceChanged();
        RGB chosenColor = this.colorSelector.getColorValue();
        if (!valueChanged) {
            if (chosenColor != null && this.previousValue == null || chosenColor == null && this.previousValue != null) {
                valueChanged = true;
            }
            if (chosenColor != null && this.previousValue != null && !chosenColor.equals(this.previousValue)) {
                valueChanged = true;
            }
        }
        if (valueChanged) {
            this.fireValueChanged("field_editor_value", this.previousValue, chosenColor);
            this.fieldModified = true;
            this.previousValue = chosenColor;
            this.setModifiedMarkOnLabel();
        }
        return valueChanged;
    }
}

