/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class StringFieldEditor
extends FieldEditor {
    private boolean isValid;
    protected String previousValue;
    protected Text textField;
    protected int widthInChars = org.eclipse.jface.preference.StringFieldEditor.UNLIMITED;
    protected int textLimit = org.eclipse.jface.preference.StringFieldEditor.UNLIMITED;
    protected String errorMessage;
    protected boolean emptyStringAllowed = true;
    protected final String emptyValue = "";
    protected int validateStrategy = 0;
    protected Validator validator;
    protected boolean textNull = true;

    public StringFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, parent);
        this.init(name, labelText);
        this.widthInChars = width;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public StringFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        this(page, tab, service, level, name, labelText, width == org.eclipse.jface.preference.StringFieldEditor.UNLIMITED ? 40 : width, 0, parent);
    }

    public StringFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        this(page, tab, service, level, name, labelText, 40, parent);
    }

    public Composite getParent() {
        return this.parent;
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String getSpecialStringValue() {
        if (!this.hasSpecialValue) {
            throw new IllegalStateException("StringField.getSpecialValue():  field does not have a special value");
        }
        if (!(this.specialValue instanceof String)) {
            throw new IllegalStateException("StringField.getSpecialValue():  special value is not a String");
        }
        return (String)this.specialValue;
    }

    public void setSpecialValue(String specialValue) {
        if (!(specialValue instanceof String)) {
            throw new IllegalStateException("StringField.setSpecialValue():  given value is not a String");
        }
        this.hasSpecialValue = true;
        this.specialValue = specialValue;
    }

    public boolean isEmptyValueAllowed() {
        return this.emptyStringAllowed;
    }

    public void setEmptyValueAllowed(boolean allowed) {
        this.emptyStringAllowed = allowed;
    }

    public String getEmptyValue() {
        return "";
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    protected void doLoad() {
        if (this.getTextControl(this.parent) != null) {
            String value = null;
            if (this.preferencesLevel != null) {
                value = this.preferencesService.getRawStringPreference(this.preferencesLevel, this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesLevel;
                this.setInherited(false);
            } else {
                value = this.preferencesService.getRawStringPreference(this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesService.getApplicableLevel(this.getPreferenceName(), this.preferencesLevel);
                this.setInherited(!this.levelFromWhichLoaded.equals(this.preferencesLevel));
            }
            this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
            this.setStringValue(value);
        }
    }

    protected void doLoadDefault() {
        if (this.getTextControl(this.parent) != null) {
            String value = this.preferencesService.getRawStringPreference("default", this.getPreferenceName());
            this.levelFromWhichLoaded = "default";
            this.setInherited(false);
            this.setPresentsDefaultValue(true);
            this.setStringValue(value);
            Text text = this.getTextControl(this.parent);
            text.setBackground(PreferencesUtilities.colorWhite);
        }
    }

    protected void doLoadLevel(String level) {
        if (this.getTextControl(this.parent) != null) {
            String value = null;
            value = this.preferencesLevel != null ? this.preferencesService.getRawStringPreference(level, this.getPreferenceName()) : this.preferencesService.getRawStringPreference(this.getPreferenceName());
            this.levelFromWhichLoaded = level;
            this.setInherited(false);
            this.setPresentsDefaultValue("default".equals(level));
            this.setStringValue(value);
        }
    }

    protected String doLoadWithInheritance() {
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int fieldLevelIndex = 0;
        String tmpPreferencesLevel = this.preferencesLevel == null ? levels[0] : this.preferencesLevel;
        for (int i = 0; i < levels.length; ++i) {
            if (!tmpPreferencesLevel.equals(levels[i])) continue;
            fieldLevelIndex = i;
            break;
        }
        String value = null;
        int levelAtWhichFound = -1;
        for (int level = fieldLevelIndex; level < levels.length; ++level) {
            value = this.preferencesService.getRawStringPreference(levels[level], this.getPreferenceName());
            if (value == null || value.equals("") && !this.isEmptyValueAllowed()) continue;
            levelAtWhichFound = level;
            levelLoaded = levels[levelAtWhichFound];
            break;
        }
        this.levelFromWhichLoaded = levelLoaded;
        this.setInherited(fieldLevelIndex != levelAtWhichFound);
        this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
        this.setStringValue(value);
        Text text = this.getTextControl(this.parent);
        if (this.isInherited()) {
            text.setBackground(PreferencesUtilities.colorBluish);
        } else {
            text.setBackground(PreferencesUtilities.colorWhite);
        }
        return levelLoaded;
    }

    protected void doStore() {
        String value = this.getTextControl(this.parent).getText();
        boolean isEmpty = value.equals("");
        if (isEmpty && !this.isEmptyValueAllowed()) {
            this.preferencesService.clearPreferenceAtLevel(this.preferencesLevel, this.getPreferenceName());
            this.loadWithInheritance();
            return;
        }
        this.preferencesService.setStringPreference(this.preferencesLevel, this.getPreferenceName(), value);
        this.fieldModified = false;
        this.levelFromWhichLoaded = this.preferencesLevel;
        this.isInherited = false;
        this.setPresentsDefaultValue(value.equals(this.preferencesService.getRawStringPreference("default", this.getPreferenceName())));
        this.getTextControl(this.parent).setBackground(PreferencesUtilities.colorWhite);
        IEclipsePreferences node = this.preferencesService.getNodeForLevel(this.preferencesLevel);
        try {
            if (node != null) {
                node.flush();
            }
        }
        catch (BackingStoreException e) {
            System.err.println("StringFieldEditor.doStore():  BackingStoreException flushing node;  node may not have been flushed:\n\tnode path = " + node.absolutePath() + ", preferences level = " + this.preferencesLevel);
        }
    }

    protected String getPreviousStringValue() {
        return this.previousValue;
    }

    protected void setPreviousStringValue(String value) {
        this.previousValue = value;
    }

    public void setFieldValueFromOutside(String newValue) {
        this.setPreviousStringValue(this.getStringValue());
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.setStringValue(newValue);
    }

    public String getStringValue() {
        String value = this.getTextControl(this.parent).getText();
        return value;
    }

    protected void setStringValue(String value) {
        if (this.getTextControl(this.parent) != null) {
            if (value == null) {
                value = "";
            }
            this.setPreviousStringValue(this.getTextControl(this.parent).getText());
            this.getTextControl(this.parent).setText(value);
            this.fieldModified = true;
            this.valueChanged();
        }
    }

    protected boolean valueChanged() {
        return this.valueChanged(false);
    }

    protected boolean valueChanged(boolean assertChanged) {
        boolean valueChanged = assertChanged || this.inheritanceChanged();
        String newValue = this.textField.getText();
        if (!valueChanged) {
            valueChanged = newValue.equals(this.getPreviousStringValue());
        }
        if (valueChanged) {
            this.fireValueChanged("field_editor_value", this.getPreviousStringValue(), newValue);
            boolean wasValid = this.isValid;
            this.refreshValidState();
            if (this.isValid != wasValid) {
                this.fireStateChanged("field_editor_is_valid", wasValid, this.isValid);
            }
            this.fieldModified = true;
            this.setPreviousStringValue(newValue);
            this.setModifiedMarkOnLabel();
            Text text = this.getTextControl(this.parent);
            if (this.isInherited()) {
                text.setBackground(PreferencesUtilities.colorBluish);
            } else {
                text.setBackground(PreferencesUtilities.colorWhite);
            }
        }
        return valueChanged;
    }

    protected boolean checkState() {
        boolean result = true;
        if (!this.emptyStringAllowed && this.getStringValue().length() == 0) {
            this.setErrorMessage(this.getFieldMessagePrefix() + "String is empty when empty string is not allowed");
            result = false;
        }
        if (result && this.getTextControl(this.parent) == null) {
            this.setErrorMessage(this.getFieldMessagePrefix() + "Text control is null; no valid value represented");
            result = false;
        }
        if (result && this.getTextControl(this.parent) != null) {
            String txt = this.getStringValue();
            boolean bl = result = txt.trim().length() > 0 || this.emptyStringAllowed;
            if (!result) {
                this.setErrorMessage(this.getFieldMessagePrefix() + "String is blank when empty string is not allowed");
            }
        }
        if (result) {
            result = result && this.doCheckState();
        }
        return this.notifyState(result);
    }

    protected boolean doCheckState() {
        String msg;
        if (this.validator != null && (msg = this.validator.validate(this.getStringValue())) != null) {
            this.setErrorMessage(msg);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public Text getTextControl() {
        return this.getTextControl(this.parent);
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 2052);
            this.textField.setFont(parent.getFont());
            String toolTipText = this.getToolTipText();
            if (toolTipText != null) {
                this.textField.setToolTipText(toolTipText);
            }
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            boolean changed;
                            StringFieldEditor.this.refreshValidState();
                            StringFieldEditor.this.setInherited(false);
                            StringFieldEditor.this.fieldModified = changed = StringFieldEditor.this.valueChanged(true);
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            StringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            StringFieldEditor.this.valueChanged();
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StringFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != org.eclipse.jface.preference.StringFieldEditor.UNLIMITED) {
            GC gc = new GC((Drawable)this.textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gd);
    }

    protected void doSetToolTip() {
        if (this.toolTipText != null) {
            this.getTextControl().setToolTipText(this.toolTipText);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public static interface Validator {
        public String validate(String var1);
    }
}

