/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.core.IMPMessages;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.IWorkspaceModel;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.runtime.PluginImages;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.ui.explorer.ExplorerMessages;
import org.eclipse.imp.ui.explorer.OutputFolderFilter;
import org.eclipse.imp.ui.explorer.ProjectExplorerActionGroup;
import org.eclipse.imp.ui.explorer.StatusBarUpdater;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ProjectExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IPropertyChangeListener {
    private TreeViewer fViewer;
    private Set<Language> fLanguages = new HashSet<Language>();
    private ITreeContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private ILabelDecorator fLabelDecorator;
    private FilterUpdater fFilterUpdater;
    private Map<Language, ILabelProvider> fLabelProviderMap = new HashMap<Language, ILabelProvider>();
    private Map<Language, ILabelDecorator> fLabelDecoratorMap = new HashMap<Language, ILabelDecorator>();
    private boolean fIsCurrentLayoutFlat = false;
    private int fRootMode;
    private Menu fContextMenu;
    private ProjectExplorerActionGroup fActionSet;
    private IMemento fMemento;
    private ISelection fLastOpenSelection;
    private ISelectionChangedListener fPostSelectionListener;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                ProjectExplorerPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    };
    private Object fWorkingSetModel;
    private boolean fLinkingEnabled;
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_FILTERS = "filters";
    static final String TAG_FILTER = "filter";
    static final String TAG_LAYOUT = "layout";
    static final String TAG_CURRENT_FRAME = "currentFramge";
    static final String TAG_ROOT_MODE = "rootMode";
    static final String SETTING_MEMENTO = "memento";
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;

    public ProjectExplorerPart() {
        this.buildProviderMaps();
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectExplorerPart.this.handlePostSelectionChanged(event);
            }
        };
    }

    private void buildProviderMaps() {
        Collection<Language> languages = LanguageRegistry.getLanguages();
        for (Language language : languages) {
            org.eclipse.imp.services.ILabelProvider labelProvider = ServiceFactory.getInstance().getLabelProvider(language);
            if (labelProvider == null) continue;
            this.fLabelProviderMap.put(language, labelProvider);
        }
        this.fLanguages.addAll(this.fLabelProviderMap.keySet());
        for (Language language : languages) {
            Object labelDecorator = null;
            if (labelDecorator == null) continue;
            this.fLabelDecoratorMap.put(language, (ILabelDecorator)labelDecorator);
        }
    }

    private void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.isLinkingEnabled() && !selection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)selection);
        }
        this.fLastOpenSelection = null;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof ISourceEntity) {
                EditorUtility.revealInEditor(part, (ISourceEntity)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public Object getAdapter(Class key) {
        if (key.equals(ISelectionProvider.class)) {
            return this.fViewer;
        }
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(ProjectExplorerPart.this.getViewer().getInput(), ProjectExplorerPart.this.getViewer().getSelection());
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        RuntimePlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        site.getPage().addPartListener(this.fPartListener);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ProjectExplorerPart.this.fActionSet.handleOpen(event);
                ProjectExplorerPart.this.fLastOpenSelection = event.getSelection();
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new StatusBarUpdater(slManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        if (this.fMemento != null) {
            this.restoreUIState(this.fMemento);
        }
        this.fMemento = null;
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
    }

    public boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    void toggleLayout() {
        this.fIsCurrentLayoutFlat = !this.fIsCurrentLayoutFlat;
        this.saveLayoutState(null);
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        if (!this.showWorkingSets() || this.fWorkingSetModel != null || this.fActionSet != null) {
            // empty if block
        }
        StructuredSelection selection = new StructuredSelection(((IStructuredSelection)this.fViewer.getSelection()).toArray());
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (isRootInputChange) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setSorter();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (isRootInputChange) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection((ISelection)selection, true);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
        if (!isRootInputChange || this.showWorkingSets()) {
            // empty if block
        }
        this.setTitleToolTip(this.getTitleToolTip());
    }

    public Object getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(this.fLabelProvider, this.fLabelDecorator));
    }

    private void makeActions() {
        this.fActionSet = new ProjectExplorerActionGroup(this);
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ProjectExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    private Object findInputElement() {
        try {
            if (this.showWorkingSets()) {
                return null;
            }
            IAdaptable input = this.getSite().getPage().getInput();
            if (input instanceof IWorkspace) {
                return JavaCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
            }
            if (input instanceof IContainer) {
                ISourceEntity element = ModelFactory.open((IContainer)input);
                if (element != null) {
                    return element;
                }
                return input;
            }
            return ModelFactory.open((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (ModelFactory.ModelException e) {
            RuntimePlugin.getInstance().logException("Error opening input element", e);
            return null;
        }
    }

    String getFrameName(Object element) {
        if (element instanceof ISourceEntity) {
            return ((ISourceEntity)element).getName();
        }
        return this.fLabelProvider.getText(element);
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof IWorkspaceModel) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = JavaElementLabels.getTextLabel((Object)input, (long)36283885813801L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IWorkspaceModel ? ExplorerMessages.ProjectExplorerPart_workspace : (element instanceof ISourceEntity ? JavaElementLabels.getTextLabel((Object)element, (long)JavaElementLabels.ALL_FULLY_QUALIFIED) : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : (element instanceof WorkingSetModel ? ExplorerMessages.ProjectExplorerPart_workingSetModel : this.fLabelProvider.getText(element))))) : ((path = ((IResource)element).getFullPath()).isRoot() ? ExplorerMessages.ProjectExplorer_title : path.makeRelative().toString());
        if (this.fRootMode == 1) {
            if (result.length() == 0) {
                return IMPMessages.format(ExplorerMessages.ProjectExplorer_toolTip, new String[]{null});
            }
            return IMPMessages.format(ExplorerMessages.ProjectExplorer_toolTip2, new String[]{result, null});
        }
        if (element != null && !(element instanceof IWorkingSet) && !(element instanceof WorkingSetModel) && this.fActionSet != null) {
            FrameList frameList = this.fActionSet.getFrameList();
            IWorkingSet ws = null;
            for (int index = frameList.getCurrentIndex(); index >= 0; --index) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (!(frame instanceof TreeFrame) || !((input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet)) continue;
                ws = (IWorkingSet)input;
                break;
            }
            if (ws != null) {
                return IMPMessages.format(ExplorerMessages.ProjectExplorer_toolTip3, new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    TreeViewer getViewer() {
        return this.fViewer;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProviderDispatcher();
    }

    private ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IWorkspaceModel) {
                    IWorkspaceModel ws = (IWorkspaceModel)parentElement;
                    return ws.getProjects();
                }
                if (parentElement instanceof ISourceProject) {
                    ISourceProject srcProject = (ISourceProject)parentElement;
                    return srcProject.getChildren();
                }
                if (parentElement instanceof ISourceFolder) {
                    ISourceFolder srcFolder = (ISourceFolder)parentElement;
                    return srcFolder.getChildren();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof IWorkspaceModel) {
                    return null;
                }
                if (element instanceof ISourceProject) {
                    try {
                        return ModelFactory.open((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (ModelFactory.ModelException e) {
                        RuntimePlugin.getInstance().logException(e.getMessage(), e);
                    }
                } else {
                    if (element instanceof ISourceFolder) {
                        return ((ISourceFolder)element).getParent();
                    }
                    if (element instanceof ICompilationUnit) {
                        ICompilationUnit cu = (ICompilationUnit)element;
                        IPath path = cu.getPath();
                        if (path.isAbsolute()) {
                            path = path.removeFirstSegments(1);
                        }
                        if (path.segmentCount() > 1) {
                            try {
                                return ModelFactory.open(cu.getFile().getProject().findMember(path.removeLastSegments(1)));
                            }
                            catch (ModelFactory.ModelException e) {
                                RuntimePlugin.getInstance().logException(e.getMessage(), e);
                            }
                        }
                        return cu.getProject();
                    }
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IWorkspaceModel) {
                    IWorkspaceModel ws = (IWorkspaceModel)element;
                    return ws.getProjects().length > 0;
                }
                if (element instanceof ISourceProject) {
                    ISourceProject sp = (ISourceProject)element;
                    return sp.getChildren().length > 0;
                }
                if (element instanceof ISourceFolder) {
                    ISourceFolder sf = (ISourceFolder)element;
                    return sf.getChildren().length > 0;
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IWorkspaceModel) {
                    IWorkspaceModel ws = (IWorkspaceModel)inputElement;
                    return ws.getProjects();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{};
        this.fViewer.addDragSupport(ops, transfers, (DragSourceListener)new DelegatingDragAdapter());
    }

    private void initDrop() {
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{};
        this.fViewer.addDropSupport(ops, transfers, (DropTargetListener)new DelegatingDropAdapter());
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Object input = this.getElementOfInput(editor.getEditorInput());
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editor.getEditorInput())) {
            this.showInput(input);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private void showInput(Object input) {
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private boolean inputIsSelected(IEditorInput editorInput) {
        return false;
    }

    private Object getElementOfInput(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            try {
                return ModelFactory.open((IResource)fileInput.getFile());
            }
            catch (ModelFactory.ModelException e) {
                RuntimePlugin.getInstance().logException("Error determining Project Explorer element corresponding to " + fileInput.getName(), e);
            }
        }
        return null;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void selectReveal(ISelection selection) {
        this.fViewer.setSelection(selection, true);
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection structuredSelection;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && this.tryToReveal(structuredSelection.getFirstElement())) {
            return true;
        }
        Object input = context.getInput();
        if (input instanceof IEditorInput) {
            Object elementOfInput = this.getElementOfInput((IEditorInput)context.getInput());
            return elementOfInput != null && this.tryToReveal(elementOfInput);
        }
        return false;
    }

    public boolean tryToReveal(Object element) {
        return this.revealElementOrParent(element);
    }

    private boolean revealElementOrParent(Object element) {
        if (this.revealAndVerify(element)) {
            return true;
        }
        return (element = this.getVisibleParent(element)) != null && this.revealAndVerify(element);
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof ISourceEntity)) {
            return object;
        }
        try {
            if (object instanceof ISourceProject) {
                return ModelFactory.open((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            }
            if (object instanceof ISourceFolder) {
                return ((ISourceFolder)object).getParent();
            }
            if (object instanceof ICompilationUnit) {
                return ModelFactory.open(((ICompilationUnit)object).getFile().getParent());
            }
        }
        catch (ModelFactory.ModelException e) {
            RuntimePlugin.getInstance().logException(e.getMessage(), e);
        }
        return null;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("org.eclipse.imp.ui.projects.linktoeditor", this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
        } else {
            IPreferenceStore store = RuntimePlugin.getInstance().getPreferenceStore();
            store.setValue(TAG_LAYOUT, this.getLayoutAsInt());
        }
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    protected void saveScrollState(IMemento memento, Tree tree) {
        ScrollBar bar = tree.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    protected void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            for (int i = 0; i < elements.length; ++i) {
                IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                Object o = elements[i];
                if (!(o instanceof ISourceEntity)) continue;
                elementMem.putString(TAG_PATH, Integer.toString(((ISourceEntity)elements[i]).hashCode()));
            }
        }
    }

    protected void saveExpansionState(IMemento memento) {
        Object[] expandedElements = this.fViewer.getVisibleExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            for (int i = 0; i < expandedElements.length; ++i) {
                IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                Object o = expandedElements[i];
                if (!(o instanceof ISourceEntity)) continue;
                elementMem.putString(TAG_PATH, Integer.toString(((ISourceEntity)expandedElements[i]).hashCode()));
            }
        }
    }

    private void restoreFilterAndSorter() {
        this.fViewer.addFilter((ViewerFilter)new OutputFolderFilter());
        this.setSorter();
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void setSorter() {
        if (this.showWorkingSets()) {
            // empty if block
        }
    }

    private void restoreUIState(IMemento memento) {
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger("org.eclipse.imp.ui.projects.linktoeditor");
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    protected void restoreScrollState(IMemento memento, Tree tree) {
        int position;
        String posStr;
        ScrollBar bar = tree.getVerticalBar();
        if (bar != null) {
            try {
                posStr = memento.getString(TAG_VERTICAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                posStr = memento.getString(TAG_HORIZONTAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    protected void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            for (int i = 0; i < elementMem.length; ++i) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element == null) continue;
                list.add(element);
            }
            this.fViewer.setSelection((ISelection)new StructuredSelection(list));
        }
    }

    protected void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            for (int i = 0; i < elementMem.length; ++i) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element == null) continue;
                elements.add(element);
            }
            this.fViewer.setExpandedElements(elements.toArray());
        }
    }

    public void dispose() {
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        RuntimePlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
            XMLMemento memento = XMLMemento.createWriteRoot((String)"projectExplorer");
            this.saveState((IMemento)memento);
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                String sectionName = this.getSectionName();
                IDialogSettings section = RuntimePlugin.getInstance().getDialogSettings().getSection(sectionName);
                if (section == null) {
                    section = RuntimePlugin.getInstance().getDialogSettings().addNewSection(sectionName);
                }
                section.put(SETTING_MEMENTO, writer.getBuffer().toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    private String getSectionName() {
        return "org.eclipse.imp.ui.internal.projectExplorer";
    }

    class FilterUpdater
    implements IResourceChangeListener {
        private StructuredViewer fViewer;

        public FilterUpdater(StructuredViewer viewer) {
            Assert.isNotNull((Object)viewer);
            this.fViewer = viewer;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            for (int i = 0; i < projDeltas.length; ++i) {
                Control ctrl;
                IResourceDelta pDelta = projDeltas[i];
                if ((pDelta.getFlags() & 0x80000) == 0 || (ctrl = this.fViewer.getControl()) == null || ctrl.isDisposed()) continue;
                ctrl.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!ctrl.isDisposed()) {
                            FilterUpdater.this.fViewer.refresh(false);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabelProviderDispatcher
    implements ILabelProvider {
        private Set<ILabelProviderListener> fListeners = new HashSet<ILabelProviderListener>();

        private LabelProviderDispatcher() {
        }

        private Set<ILabelProvider> getRelevantProvidersFor(IProject project) {
            HashSet<ILabelProvider> providers = new HashSet<ILabelProvider>();
            for (Language lang : ProjectExplorerPart.this.fLanguages) {
                String natureId = lang.getNatureID();
                try {
                    if (!project.hasNature(natureId) || !ProjectExplorerPart.this.fLabelProviderMap.containsKey(lang)) continue;
                    providers.add((ILabelProvider)ProjectExplorerPart.this.fLabelProviderMap.get(lang));
                }
                catch (CoreException e) {
                    RuntimePlugin.getInstance().logException("Unable to query project natures of " + project.getName(), e);
                }
            }
            return providers;
        }

        public Image getImage(Object element) {
            if (element instanceof IResource || element instanceof ISourceEntity) {
                IResource res = element instanceof ISourceEntity ? ((ISourceEntity)element).getResource() : (IResource)element;
                IProject project = res.getProject();
                Set<ILabelProvider> relevantProviders = this.getRelevantProvidersFor(project);
                for (ILabelProvider provider : relevantProviders) {
                    Image image = provider.getImage(element);
                    if (image == null) continue;
                    return image;
                }
            }
            if (element instanceof ISourceProject) {
                return PluginImages.get("project.gif");
            }
            if (element instanceof ISourceFolder) {
                return PluginImages.get("folder.gif");
            }
            if (element instanceof ICompilationUnit) {
                return PluginImages.get("file.gif");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ISourceProject) {
                ISourceProject srcProject = (ISourceProject)element;
                return srcProject.getRawProject().getName();
            }
            if (element instanceof ISourceFolder) {
                ISourceFolder srcFolder = (ISourceFolder)element;
                return srcFolder.getName();
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                return cu.getName();
            }
            if (element instanceof IResource) {
                IResource res = (IResource)element;
                IProject project = res.getProject();
                Set<ILabelProvider> relevantProviders = this.getRelevantProvidersFor(project);
                for (ILabelProvider provider : relevantProviders) {
                    String text = provider.getText(element);
                    if (text == null) continue;
                    return text;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            this.fListeners.add(listener);
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof IResource) {
                IResource res = (IResource)element;
                IProject project = res.getProject();
                Set<ILabelProvider> relevantProviders = this.getRelevantProvidersFor(project);
                for (ILabelProvider provider : relevantProviders) {
                    if (!provider.isLabelProperty(element, property)) continue;
                    return true;
                }
            }
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fListeners.remove(listener);
        }
    }
}

