/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.annotations.NonNull;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchy;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer {
    protected final boolean isStatic;
    protected final String classType;
    protected final String signature;
    @NonNull
    protected final Instruction[] instructions;
    protected final ExceptionHandler[][] handlers;
    protected ClassHierarchyProvider hierarchy;
    protected int maxStack;
    protected int maxLocals;
    protected String[][] stacks;
    protected String[][] locals;
    protected int[] stackSizes;
    protected BitSet basicBlockStarts;
    protected int[][] backEdges;
    protected static final String[] noStrings = new String[0];
    protected static final int[] noEdges = new int[0];

    public Analyzer(boolean isStatic, String classType, String signature, Instruction[] instructions, ExceptionHandler[][] handlers) {
        this.classType = classType;
        this.isStatic = isStatic;
        this.signature = signature;
        this.instructions = instructions;
        this.handlers = handlers;
    }

    public final void setClassHierarchy(ClassHierarchyProvider h) {
        this.hierarchy = h;
    }

    private void addBackEdge(int from, int to) {
        int[] oldEdges = this.backEdges[from];
        if (oldEdges == null) {
            this.backEdges[from] = new int[]{to};
        } else if (oldEdges[oldEdges.length - 1] < 0) {
            int left = 1;
            int right = oldEdges.length - 1;
            while (true) {
                if (right - left < 2) {
                    if (oldEdges[left] < 0) break;
                    if (oldEdges[right] >= 0) {
                        throw new Error("Failed binary search");
                    }
                    left = right;
                    break;
                }
                int mid = (left + right) / 2;
                if (oldEdges[mid] < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            oldEdges[left] = to;
        } else {
            int[] newEdges = new int[oldEdges.length * 2];
            System.arraycopy(oldEdges, 0, newEdges, 0, oldEdges.length);
            newEdges[oldEdges.length] = to;
            for (int i = oldEdges.length + 1; i < newEdges.length; ++i) {
                newEdges[i] = -1;
            }
            this.backEdges[from] = newEdges;
        }
    }

    public final int[][] getBackEdges() {
        int i;
        if (this.backEdges != null) {
            return this.backEdges;
        }
        this.backEdges = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            Instruction instr = this.instructions[i];
            int[] targets = instr.getBranchTargets();
            for (int j = 0; j < targets.length; ++j) {
                this.addBackEdge(targets[j], i);
            }
            ExceptionHandler[] hs = this.handlers[i];
            for (int j = 0; j < hs.length; ++j) {
                this.addBackEdge(hs[j].getHandler(), i);
            }
        }
        for (i = 0; i < this.backEdges.length; ++i) {
            int[] back = this.backEdges[i];
            if (back == null) {
                this.backEdges[i] = noEdges;
                continue;
            }
            if (back[back.length - 1] >= 0) continue;
            int j = back.length;
            while (back[j - 1] < 0) {
                --j;
            }
            int[] newBack = new int[j];
            System.arraycopy(back, 0, newBack, 0, newBack.length);
            this.backEdges[i] = newBack;
        }
        return this.backEdges;
    }

    public final boolean isSubtypeOf(String t1, String t2) {
        return ClassHierarchy.isSubtypeOf(this.hierarchy, t1, t2) != 1;
    }

    public final String findCommonSupertype(String t1, String t2) {
        return ClassHierarchy.findCommonSupertype(this.hierarchy, t1, t2);
    }

    public final BitSet getBasicBlockStarts() {
        int j;
        int i;
        if (this.basicBlockStarts != null) {
            return this.basicBlockStarts;
        }
        BitSet r = new BitSet(this.instructions.length);
        r.set(0);
        for (i = 0; i < this.instructions.length; ++i) {
            int[] targets = this.instructions[i].getBranchTargets();
            for (j = 0; j < targets.length; ++j) {
                r.set(targets[j]);
            }
        }
        for (i = 0; i < this.handlers.length; ++i) {
            ExceptionHandler[] hs = this.handlers[i];
            if (hs == null) continue;
            for (j = 0; j < hs.length; ++j) {
                r.set(hs[j].getHandler());
            }
        }
        this.basicBlockStarts = r;
        return r;
    }

    public final Instruction[] getInstructions() {
        return this.instructions;
    }

    private void getReachableRecursive(int from, BitSet reachable, boolean followHandlers, BitSet mask) throws IllegalArgumentException {
        if (from < 0) {
            throw new IllegalArgumentException("from < 0");
        }
        while (true) {
            if (reachable.get(from) || mask != null && !mask.get(from)) {
                return;
            }
            reachable.set(from);
            Instruction instr = this.instructions[from];
            int[] targets = instr.getBranchTargets();
            for (int i = 0; i < targets.length; ++i) {
                this.getReachableRecursive(targets[i], reachable, followHandlers, mask);
            }
            if (followHandlers) {
                ExceptionHandler[] hs = this.handlers[from];
                for (int i = 0; i < hs.length; ++i) {
                    this.getReachableRecursive(hs[i].getHandler(), reachable, followHandlers, mask);
                }
            }
            if (!instr.isFallThrough()) break;
            ++from;
        }
    }

    public final BitSet getReachableFrom(int from) {
        return this.getReachableFrom(from, true, null);
    }

    public final void getReachableFromUpdate(int from, BitSet reachable, boolean followHandlers, BitSet mask) {
        if (reachable == null) {
            throw new IllegalArgumentException("reachable is null");
        }
        reachable.clear();
        this.getReachableRecursive(from, reachable, followHandlers, mask);
    }

    public final BitSet getReachableFrom(int from, boolean followHandlers, BitSet mask) {
        BitSet reachable = new BitSet();
        this.getReachableRecursive(from, reachable, followHandlers, mask);
        return reachable;
    }

    private void getReachingRecursive(int to, BitSet reaching, BitSet mask) {
        while (true) {
            if (reaching.get(to) || mask != null && !mask.get(to)) {
                return;
            }
            reaching.set(to);
            int[] targets = this.backEdges[to];
            for (int i = 0; i < targets.length; ++i) {
                this.getReachingRecursive(targets[i], reaching, mask);
            }
            if (to <= 0 || !this.instructions[to - 1].isFallThrough()) break;
            --to;
        }
    }

    private void getReachingBase(int to, BitSet reaching, BitSet mask) {
        int[] targets = this.backEdges[to];
        for (int i = 0; i < targets.length; ++i) {
            this.getReachingRecursive(targets[i], reaching, mask);
        }
        if (to > 0 && this.instructions[to - 1].isFallThrough()) {
            this.getReachingRecursive(to - 1, reaching, mask);
        }
    }

    public final void getReachingToUpdate(int to, BitSet reaching, BitSet mask) {
        if (reaching == null) {
            throw new IllegalArgumentException("reaching is null");
        }
        this.getBackEdges();
        reaching.clear();
        this.getReachingBase(to, reaching, mask);
    }

    public final BitSet getReachingTo(int to, BitSet mask) {
        this.getBackEdges();
        BitSet reaching = new BitSet();
        this.getReachingBase(to, reaching, mask);
        return reaching;
    }

    public final BitSet getReachingTo(int to) {
        return this.getReachingTo(to, null);
    }

    private void computeStackSizesAt(int[] stackSizes, int i, int size) throws FailureException {
        while (true) {
            if (stackSizes[i] >= 0) {
                if (size != stackSizes[i]) {
                    throw new FailureException(i, "Stack size mismatch", null);
                }
                return;
            }
            stackSizes[i] = size;
            Instruction instr = this.instructions[i];
            if (instr instanceof DupInstruction) {
                size += ((DupInstruction)instr).getSize();
            } else if (!(instr instanceof SwapInstruction)) {
                size -= instr.getPoppedCount();
                if (instr.getPushedWordSize() > 0) {
                    ++size;
                }
            }
            int[] targets = instr.getBranchTargets();
            for (int j = 0; j < targets.length; ++j) {
                this.computeStackSizesAt(stackSizes, targets[j], size);
            }
            ExceptionHandler[] hs = this.handlers[i];
            for (int j = 0; j < hs.length; ++j) {
                this.computeStackSizesAt(stackSizes, hs[j].getHandler(), 1);
            }
            if (!instr.isFallThrough()) {
                return;
            }
            ++i;
        }
    }

    private String[] cutArray(String[] a, int len) {
        if (len == 0) {
            return noStrings;
        }
        String[] r = new String[len];
        System.arraycopy(a, 0, r, 0, len);
        return r;
    }

    private boolean mergeTypes(int i, String[] curStack, int curStackSize, String[] curLocals, int curLocalsSize, List<PathElement> path) throws FailureException {
        String t;
        int j;
        boolean changed = false;
        if (this.stacks[i] == null) {
            this.stacks[i] = this.cutArray(curStack, curStackSize);
            changed = true;
        } else {
            String[] st = this.stacks[i];
            if (st.length != curStackSize) {
                throw new FailureException(i, "Stack size mismatch: " + st.length + ", " + curStackSize, path);
            }
            for (j = 0; j < curStackSize; ++j) {
                t = this.findCommonSupertype(st[j], curStack[j]);
                if (t == st[j]) continue;
                if (t == null) {
                    throw new FailureException(i, "Stack type mismatch at " + j + " (" + st[j] + " vs " + curStack[j] + ")", path);
                }
                st[j] = t;
                changed = true;
            }
        }
        if (this.locals[i] == null) {
            this.locals[i] = this.cutArray(curLocals, curLocalsSize);
            changed = true;
        } else {
            String[] ls = this.locals[i];
            for (j = 0; j < ls.length; ++j) {
                t = this.findCommonSupertype(ls[j], curLocals[j]);
                if (t == ls[j]) continue;
                ls[j] = t;
                changed = true;
            }
        }
        return changed;
    }

    private void computeTypes(int i, TypeVisitor visitor, BitSet makeTypesAt, List<PathElement> path) throws FailureException {
        boolean restart;
        final String[] curStack = new String[this.maxStack];
        final String[] curLocals = new String[this.maxLocals];
        block0: do {
            if (path != null) {
                path.add(new PathElement(i, this.stacks[i], this.locals[i]));
            }
            int curStackSize = this.stacks[i].length;
            System.arraycopy(this.stacks[i], 0, curStack, 0, curStackSize);
            final int[] curLocalsSize = new int[]{this.locals[i].length};
            System.arraycopy(this.locals[i], 0, curLocals, 0, curLocalsSize[0]);
            Instruction.Visitor localsUpdate = new Instruction.Visitor(){

                public void visitLocalLoad(LoadInstruction instruction) {
                    String t;
                    curStack[0] = t = curLocals[instruction.getVarIndex()];
                }

                public void visitLocalStore(StoreInstruction instruction) {
                    int index = instruction.getVarIndex();
                    curLocals[index] = curStack[0];
                    if (index >= curLocalsSize[0]) {
                        curLocalsSize[0] = index + 1;
                    }
                }
            };
            restart = false;
            do {
                Instruction instr;
                int popped;
                if (curStackSize < (popped = (instr = this.instructions[i]).getPoppedCount())) {
                    throw new FailureException(i, "Stack underflow", path);
                }
                if (visitor != null) {
                    visitor.setState(i, path, curStack, curLocals);
                    instr.visit(visitor);
                    if (!visitor.shouldContinue()) {
                        return;
                    }
                }
                if (instr instanceof DupInstruction) {
                    DupInstruction d = (DupInstruction)instr;
                    int size = d.getSize();
                    System.arraycopy(curStack, popped, curStack, popped + size, curStackSize - popped);
                    System.arraycopy(curStack, 0, curStack, popped, size);
                    curStackSize += size;
                } else if (instr instanceof SwapInstruction) {
                    String s = curStack[0];
                    curStack[0] = curStack[1];
                    curStack[1] = s;
                } else {
                    String pushed = instr.getPushedType(curStack);
                    if (pushed != null) {
                        System.arraycopy(curStack, popped, curStack, 1, curStackSize - popped);
                        curStack[0] = Util.getStackType(pushed);
                        instr.visit(localsUpdate);
                        curStackSize -= popped - 1;
                    } else {
                        instr.visit(localsUpdate);
                        System.arraycopy(curStack, popped, curStack, 0, curStackSize - popped);
                        curStackSize -= popped;
                    }
                }
                int[] targets = instr.getBranchTargets();
                for (int j = 0; j < targets.length; ++j) {
                    if (!this.mergeTypes(targets[j], curStack, curStackSize, curLocals, curLocalsSize[0], path)) continue;
                    this.computeTypes(targets[j], visitor, makeTypesAt, path);
                }
                if (!instr.isFallThrough()) continue block0;
            } while (!makeTypesAt.get(++i));
            if (this.mergeTypes(i, curStack, curStackSize, curLocals, curLocalsSize[0], path)) {
                restart = true;
                continue;
            }
            if (path != null) {
                path.remove(path.size() - 1);
            }
            return;
        } while (restart);
        if (path != null) {
            path.remove(path.size() - 1);
        }
    }

    public int[] getStackSizes() throws FailureException {
        if (this.stackSizes != null) {
            return this.stackSizes;
        }
        this.stackSizes = new int[this.instructions.length];
        for (int i = 0; i < this.stackSizes.length; ++i) {
            this.stackSizes[i] = -1;
        }
        this.computeStackSizesAt(this.stackSizes, 0, 0);
        return this.stackSizes;
    }

    private void computeMaxLocals() {
        this.maxLocals = this.locals[0].length;
        for (int i = 0; i < this.instructions.length; ++i) {
            Instruction instr = this.instructions[i];
            if (instr instanceof LoadInstruction) {
                this.maxLocals = Math.max(this.maxLocals, ((LoadInstruction)instr).getVarIndex() + 1);
                continue;
            }
            if (!(instr instanceof StoreInstruction)) continue;
            this.maxLocals = Math.max(this.maxLocals, ((StoreInstruction)instr).getVarIndex() + 1);
        }
    }

    protected final void initTypeInfo() throws FailureException {
        this.stacks = new String[this.instructions.length][];
        this.locals = new String[this.instructions.length][];
        this.stacks[0] = noStrings;
        this.locals[0] = Util.getParamsTypesInLocals(this.isStatic ? null : this.classType, this.signature);
        int[] stackSizes = this.getStackSizes();
        this.maxStack = 0;
        for (int i = 0; i < stackSizes.length; ++i) {
            this.maxStack = Math.max(this.maxStack, stackSizes[i]);
        }
        this.computeMaxLocals();
    }

    public final void computeTypes(TypeVisitor v, BitSet makeTypesAt, boolean wantPath) throws FailureException {
        this.initTypeInfo();
        this.computeTypes(0, v, makeTypesAt, wantPath ? new ArrayList() : null);
    }

    public final String[][] getLocalTypes() {
        return this.locals;
    }

    public final String[][] getStackTypes() {
        return this.stacks;
    }

    protected Analyzer(MethodData info) {
        this(info.getIsStatic(), info.getClassType(), info.getSignature(), info.getInstructions(), info.getHandlers());
    }

    public static Analyzer createAnalyzer(MethodData info) {
        if (info == null) {
            throw new IllegalArgumentException("info is null");
        }
        return new Analyzer(info);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class TypeVisitor
    extends Instruction.Visitor {
        public abstract void setState(int var1, List<PathElement> var2, String[] var3, String[] var4);

        public abstract boolean shouldContinue();
    }

    public static final class PathElement {
        final int index;
        final String[] stack;
        final String[] locals;

        PathElement(int index, String[] stack, String[] locals) {
            this.stack = (String[])stack.clone();
            this.locals = (String[])locals.clone();
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getLocals() {
            return this.locals;
        }

        public String[] getStack() {
            return this.stack;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FailureException
    extends Exception {
        private static final long serialVersionUID = -7663520961403117526L;
        private final int offset;
        private final String reason;
        private List<PathElement> path;

        FailureException(int offset, String reason, List<PathElement> path) {
            super(reason + " at offset " + offset);
            this.offset = offset;
            this.reason = reason;
            this.path = path;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getReason() {
            return this.reason;
        }

        public List<PathElement> getPath() {
            return this.path;
        }

        void setPath(List<PathElement> path) {
            this.path = path;
        }

        public void printPath(Writer w) throws IOException {
            if (this.path != null) {
                for (int i = 0; i < this.path.size(); ++i) {
                    int j;
                    PathElement elem = this.path.get(i);
                    String[] stack = elem.stack;
                    String[] locals = elem.locals;
                    w.write("Offset " + elem.index + ": [");
                    for (j = 0; j < stack.length; ++j) {
                        if (j > 0) {
                            w.write(",");
                        }
                        w.write(stack[j]);
                    }
                    w.write("], [");
                    for (j = 0; j < locals.length; ++j) {
                        if (j > 0) {
                            w.write(",");
                        }
                        w.write(locals[j] == null ? "?" : locals[j]);
                    }
                    w.write("]\n");
                }
            }
        }
    }
}

