/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.browser;

import java.util.List;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.browser.FactBrowserView;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.ui.graph.Editor;
import org.eclipse.imp.pdb.ui.graph.GraphBuilder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ShowAction
implements IViewActionDelegate {
    private FactBrowserView factBrowser;
    private final FactBase factBase = FactBase.getInstance();

    public void init(IViewPart view) {
        this.factBrowser = (FactBrowserView)view;
    }

    public void run(IAction action) {
        List<IFactKey> keys = this.factBrowser.getCurrentSelection();
        try {
            for (IFactKey key : keys) {
                Editor.open(this.factBase.getFact(key));
            }
        }
        catch (AnalysisException analysisException) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean canShow = true;
        List<IFactKey> keys = this.factBrowser.getCurrentSelection();
        for (IFactKey key : keys) {
            canShow &= GraphBuilder.canShow(key.getType());
        }
        action.setEnabled(canShow);
    }
}

