/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import java.net.URL;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceLocationValue
extends Value
implements ISourceLocation {
    private final URL fPath;
    private final int fStartOffset;
    private final int fLength;
    private final int fStartLine;
    private final int fEndLine;
    private final int fStartCol;
    private final int fEndCol;

    SourceLocationValue(URL path, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        super(TypeFactory.getInstance().sourceLocationType());
        this.fPath = path;
        this.fStartOffset = startOffset;
        this.fLength = length;
        this.fStartLine = startLine;
        this.fEndLine = endLine;
        this.fStartCol = startCol;
        this.fEndCol = endCol;
    }

    @Override
    public URL getURL() {
        return this.fPath;
    }

    @Override
    public int getEndColumn() {
        return this.fEndCol;
    }

    @Override
    public int getEndLine() {
        return this.fEndLine;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getBeginColumn() {
        return this.fStartCol;
    }

    @Override
    public int getBeginLine() {
        return this.fStartLine;
    }

    @Override
    public int getOffset() {
        return this.fStartOffset;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            SourceLocationValue other = (SourceLocationValue)o;
            return this.fPath.toString().equals(other.fPath.toString()) && other.fStartOffset == this.fStartOffset && other.fLength == this.fLength && other.fStartLine == this.fStartLine && other.fEndLine == this.fEndLine && other.fStartCol == this.fStartCol && other.fEndCol == this.fEndCol;
        }
        return false;
    }

    public int hashCode() {
        return 1923 * this.fPath.hashCode() + 24551 + (this.fStartOffset << 5) + (this.fLength << 10) + (this.fStartLine << 15) + (this.fEndLine << 20) + (this.fStartCol << 25) + (this.fEndCol << 30);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitSourceLocation(this);
    }
}

