/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tuple
extends Value
implements ITuple {
    protected final IValue[] fElements;

    Tuple(IValue ... elements) {
        super(TypeFactory.getInstance().tupleType(elements));
        this.fElements = elements;
    }

    private Tuple(Tuple other, int i, IValue elem) {
        super(other);
        this.fElements = (IValue[])other.fElements.clone();
        this.fElements[i] = elem;
    }

    private Tuple(Type tupleType, IValue[] elems) {
        super(tupleType);
        this.fElements = elems;
    }

    @Override
    public int arity() {
        return this.fElements.length;
    }

    @Override
    public IValue get(int i) throws IndexOutOfBoundsException {
        try {
            return this.fElements[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Tuple index " + i + " is larger than tuple width " + this.arity());
        }
    }

    @Override
    public IValue get(String label) throws FactTypeUseException {
        return this.fElements[this.fType.getFieldIndex(label)];
    }

    @Override
    public Iterator<IValue> iterator() {
        return new Iterator<IValue>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < Tuple.this.arity();
            }

            @Override
            public IValue next() {
                return Tuple.this.get(this.count++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove elements from a tuple");
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            Tuple peer = (Tuple)o;
            if (!this.fType.comparable(peer.fType)) {
                return false;
            }
            int arity = this.arity();
            if (arity != peer.arity()) {
                return false;
            }
            for (int i = 0; i < arity; ++i) {
                if (((Object)this.get(i)).equals(peer.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.fElements.length; ++i) {
            hash = hash << 1 ^ hash >> 1 ^ this.fElements[i].hashCode();
        }
        return hash;
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitTuple(this);
    }

    @Override
    public ITuple set(int i, IValue arg) throws IndexOutOfBoundsException {
        return new Tuple(this, i, arg);
    }

    @Override
    public ITuple set(String label, IValue arg) throws FactTypeUseException {
        int i = this.fType.getFieldIndex(label);
        return new Tuple(this, i, arg);
    }

    @Override
    public IValue select(int ... fields) throws IndexOutOfBoundsException {
        Type type = this.fType.select(fields);
        if (type.isTupleType()) {
            return this.doSelect(type, fields);
        }
        return this.get(fields[0]);
    }

    private IValue doSelect(Type type, int ... fields) throws IndexOutOfBoundsException {
        IValue[] elems = new IValue[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            elems[i] = this.get(fields[i]);
        }
        return new Tuple(type, elems);
    }

    @Override
    public IValue select(String ... fields) throws FactTypeUseException {
        Type type = this.fType.select(fields);
        if (type.isTupleType()) {
            int[] indexes = new int[fields.length];
            int i = 0;
            for (String name : fields) {
                indexes[i] = type.getFieldIndex(name);
            }
            return this.doSelect(type, indexes);
        }
        return this.get(fields[0]);
    }
}

