/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.HashMap;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedElementTypeException;
import org.eclipse.imp.pdb.facts.impl.BaseValueFactory;
import org.eclipse.imp.pdb.facts.impl.reference.Constructor;
import org.eclipse.imp.pdb.facts.impl.reference.List;
import org.eclipse.imp.pdb.facts.impl.reference.Map;
import org.eclipse.imp.pdb.facts.impl.reference.Node;
import org.eclipse.imp.pdb.facts.impl.reference.Relation;
import org.eclipse.imp.pdb.facts.impl.reference.Set;
import org.eclipse.imp.pdb.facts.impl.reference.Tuple;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

public class ValueFactory
extends BaseValueFactory {
    private static final ValueFactory sInstance = new ValueFactory();

    public static ValueFactory getInstance() {
        return sInstance;
    }

    private ValueFactory() {
    }

    private void checkNull(Object ... args) {
        for (Object a : args) {
            if (a != null) continue;
            throw new NullPointerException();
        }
    }

    public IRelation relation(Type tupleType) {
        this.checkNull(tupleType);
        return this.relationWriter(tupleType).done();
    }

    public IRelation relation(IValue ... tuples) {
        this.checkNull(tuples);
        Type elementType = this.lub(tuples);
        if (!elementType.isTupleType()) {
            TypeFactory tf = TypeFactory.getInstance();
            throw new UnexpectedElementTypeException(tf.tupleType(tf.voidType()), elementType);
        }
        ISetWriter rw = this.setWriter(elementType);
        rw.insert(tuples);
        return (IRelation)rw.done();
    }

    public IRelationWriter relationWriter(Type tupleType) {
        this.checkNull(tupleType);
        return Relation.createRelationWriter(tupleType);
    }

    public ISet set(Type eltType) {
        this.checkNull(eltType);
        return this.setWriter(eltType).done();
    }

    public ISetWriter setWriter(Type eltType) {
        this.checkNull(eltType);
        if (eltType.isTupleType()) {
            return this.relationWriter(eltType);
        }
        return Set.createSetWriter(eltType);
    }

    public ISet set(IValue ... elems) throws FactTypeUseException {
        this.checkNull(elems);
        Type elementType = this.lub(elems);
        ISetWriter sw = this.setWriter(elementType);
        sw.insert(elems);
        return sw.done();
    }

    public IList list(Type eltType) {
        this.checkNull(eltType);
        return this.listWriter(eltType).done();
    }

    public IListWriter listWriter(Type eltType) {
        this.checkNull(eltType);
        return List.createListWriter(eltType);
    }

    public IList list(IValue ... rest) {
        this.checkNull(rest);
        Type eltType = this.lub(rest);
        IListWriter lw = this.listWriter(eltType);
        lw.append(rest);
        return lw.done();
    }

    private Type lub(IValue ... elems) {
        this.checkNull(elems);
        Type elementType = TypeFactory.getInstance().voidType();
        for (IValue elem : elems) {
            elementType = elementType.lub(elem.getType());
        }
        return elementType;
    }

    public ITuple tuple() {
        return new Tuple(new IValue[0]);
    }

    public ITuple tuple(IValue ... args) {
        this.checkNull(args);
        IValue[] tmp = new IValue[args.length];
        System.arraycopy(args, 0, tmp, 0, args.length);
        return new Tuple(tmp);
    }

    public INode node(String name) {
        this.checkNull(name);
        return new Node(name);
    }

    public INode node(String name, IValue ... children) {
        this.checkNull(name);
        this.checkNull(children);
        return new Node(name, children);
    }

    public IConstructor constructor(Type constructorType, IValue ... children) {
        this.checkNull(constructorType);
        this.checkNull(children);
        HashMap<Type, Type> bindings = new HashMap<Type, Type>();
        TypeFactory tf = TypeFactory.getInstance();
        constructorType.getFieldTypes().match(tf.tupleType(children), bindings);
        return new Constructor(constructorType.instantiate(new TypeStore(new TypeStore[0]), bindings), children);
    }

    public IConstructor constructor(Type constructorType) {
        this.checkNull(constructorType);
        return new Constructor(constructorType);
    }

    public IMap map(Type keyType, Type valueType) {
        this.checkNull(keyType);
        this.checkNull(valueType);
        return this.mapWriter(keyType, valueType).done();
    }

    public IMapWriter mapWriter(Type keyType, Type valueType) {
        this.checkNull(keyType);
        this.checkNull(valueType);
        return Map.createMapWriter(keyType, valueType);
    }
}

