/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.SetType;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RelationType
extends SetType {
    final Type fTupleType;

    RelationType(Type tupleType) {
        super(tupleType);
        this.fTupleType = tupleType;
    }

    @Override
    public int getArity() {
        return this.fTupleType.getArity();
    }

    @Override
    public Type getFieldType(int i) {
        return this.fTupleType.getFieldType(i);
    }

    @Override
    public Type getFieldType(String label) {
        return this.fTupleType.getFieldType(label);
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.fTupleType.getFieldIndex(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fTupleType.hasField(fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return this.fTupleType;
    }

    @Override
    public String getFieldName(int i) {
        return this.fTupleType.getFieldName(i);
    }

    @Override
    public boolean isRelationType() {
        return true;
    }

    @Override
    public boolean isSubtypeOf(Type o) {
        if (o.isRelationType()) {
            return this.fTupleType.isSubtypeOf(o.getFieldTypes());
        }
        return super.isSubtypeOf(o);
    }

    @Override
    public Type lub(Type o) {
        if (o.isRelationType()) {
            return TypeFactory.getInstance().setType(this.fTupleType.lub(o.getFieldTypes()));
        }
        return super.lub(o);
    }

    @Override
    public int hashCode() {
        return 58453 + 14323 * this.fTupleType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RelationType)) {
            return false;
        }
        RelationType other = (RelationType)obj;
        return this.fTupleType == other.fTupleType;
    }

    @Override
    public String toString() {
        if (this.fTupleType.isVoidType() || this.fTupleType.getArity() == 1 && this.fTupleType.getFieldType(0).isVoidType()) {
            return "set[void]";
        }
        StringBuffer b = new StringBuffer();
        b.append("rel[");
        int idx = 0;
        for (Type t : this.fTupleType) {
            if (idx++ > 0) {
                b.append(", ");
            }
            b.append(t.toString());
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public boolean hasFieldNames() {
        return this.fTupleType.hasFieldNames();
    }

    @Override
    public Type compose(Type other) throws FactTypeUseException {
        return TypeFactory.getInstance().relTypeFromTuple(this.getFieldTypes().compose(other.getFieldTypes()));
    }

    @Override
    public Type carrier() {
        return this.getFieldTypes().carrier();
    }

    @Override
    public Type closure() {
        if (this.getElementType().isVoidType()) {
            return this;
        }
        if (this.getArity() != 2 || !this.getFieldType(0).comparable(this.getFieldType(1))) {
            throw new IllegalOperationException("closure", this);
        }
        Type lub = this.getFieldType(0).lub(this.getFieldType(1));
        TypeFactory tf = TypeFactory.getInstance();
        if (this.hasFieldNames()) {
            return tf.relType(lub, this.getFieldName(0), lub, this.getFieldName(1));
        }
        return tf.relType(lub, lub);
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitRelationType(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return f.relation(this.fTupleType);
    }

    @Override
    public IValue make(IValueFactory f, IValue ... elems) {
        return f.relation(elems);
    }

    @Override
    public IRelationWriter writer(IValueFactory f) {
        return f.relationWriter(this.fTupleType);
    }
}

