/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.core.Assert;

public class OrConstraint
implements IConstraint {
    private final IConstraint[] fConstraints;

    OrConstraint(IConstraint[] constraints) {
        Assert.isNotNull((Object)constraints);
        this.fConstraints = OrConstraint.sort(OrConstraint.getCopy(constraints));
    }

    private static IConstraint[] getCopy(IConstraint[] constraints) {
        List<IConstraint> l = Arrays.asList(constraints);
        return l.toArray(new IConstraint[l.size()]);
    }

    private static IConstraint[] sort(IConstraint[] constraints) {
        Arrays.sort(constraints, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o2.toString().compareTo(o1.toString());
            }
        });
        return constraints;
    }

    public boolean isSimpleTypeConstraint() {
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.fConstraints.length; ++i) {
            IConstraint constraint = this.fConstraints[i];
            if (i > 0) {
                buff.append(" or ");
            }
            buff.append(constraint.toString());
        }
        return buff.toString();
    }

    public IConstraint[] getConstraints() {
        return this.fConstraints;
    }
}

