/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.imp.analysis.ConstraintsPlugin;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.type.constraints.PolyglotConstraintCreator;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.refactoring.IFileVisitor;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.ArrayInit;
import polyglot.ast.ArrayTypeNode;
import polyglot.ast.Assert;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.BooleanLit;
import polyglot.ast.Branch;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Case;
import polyglot.ast.Cast;
import polyglot.ast.Catch;
import polyglot.ast.CharLit;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassLit;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Do;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.FloatLit;
import polyglot.ast.For;
import polyglot.ast.Formal;
import polyglot.ast.If;
import polyglot.ast.Import;
import polyglot.ast.Initializer;
import polyglot.ast.Instanceof;
import polyglot.ast.IntLit;
import polyglot.ast.Labeled;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NullLit;
import polyglot.ast.NumLit;
import polyglot.ast.PackageNode;
import polyglot.ast.Prefix;
import polyglot.ast.Return;
import polyglot.ast.SourceFile;
import polyglot.ast.Special;
import polyglot.ast.StringLit;
import polyglot.ast.Switch;
import polyglot.ast.SwitchBlock;
import polyglot.ast.Synchronized;
import polyglot.ast.Throw;
import polyglot.ast.Try;
import polyglot.ast.Unary;
import polyglot.ast.While;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConstraintCollector
implements IFileVisitor {
    private final ConstraintVisitor fConstraintVisitor;
    private final List<IConstraint> fConstraints = new ArrayList<IConstraint>();
    private final PolyglotConstraintCreator fCreator;

    public TypeConstraintCollector(PolyglotConstraintCreator creator) {
        this.fCreator = creator;
        this.fConstraintVisitor = new ConstraintVisitor(this.fConstraints, this.fCreator);
    }

    public void clearConstraints() {
        this.fConstraints.clear();
    }

    public void enterFile(IFile file) {
        System.out.println("Generating constraints for file" + file.getLocation().toPortableString());
        try {
            ISourceProject srcProject = ModelFactory.open((IProject)file.getProject());
            ICompilationUnit unit = ModelFactory.open((IFile)file, (ISourceProject)srcProject);
            this.fCreator.getVariableFactory().setCompilationUnit(unit);
        }
        catch (ModelFactory.ModelException e) {
            ConstraintsPlugin.getInstance().logException("Error while generating type constraints for " + file.getProjectRelativePath(), e);
        }
    }

    public void leaveFile(IFile file) {
        System.out.println("Done generating constraints for file" + file.getLocation().toPortableString());
        this.dumpConstraints(System.out);
    }

    public NodeVisitor getVisitor() {
        return this.fConstraintVisitor;
    }

    public List<IConstraint> getConstraints() {
        return this.fConstraints;
    }

    public void dumpConstraints(PrintStream out) {
        for (IConstraint constraint : this.fConstraints) {
            out.println(constraint.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConstraintVisitor
    extends NodeVisitor {
        private final List<IConstraint> fConstraints;
        private final PolyglotConstraintCreator fCreator;

        private ConstraintVisitor(List<IConstraint> constraints, PolyglotConstraintCreator creator) {
            this.fConstraints = constraints;
            this.fCreator = creator;
        }

        private void addAll(IConstraint[] constraints) {
            for (int i = 0; i < constraints.length; ++i) {
                IConstraint constraint = constraints[i];
                this.fConstraints.add(constraint);
            }
        }

        public NodeVisitor enter(Node n) {
            if (n instanceof ArrayAccess) {
                this.addAll(this.fCreator.createFor((ArrayAccess)n));
            } else if (n instanceof ArrayAccessAssign) {
                this.addAll(this.fCreator.createFor((ArrayAccessAssign)n));
            } else if (n instanceof ArrayInit) {
                this.addAll(this.fCreator.createFor((ArrayInit)n));
            } else if (n instanceof ArrayTypeNode) {
                this.addAll(this.fCreator.createFor((ArrayTypeNode)n));
            } else if (n instanceof Assert) {
                this.addAll(this.fCreator.createFor((Assert)n));
            } else if (n instanceof Assign) {
                this.addAll(this.fCreator.createFor((Assign)n));
            } else if (n instanceof Binary) {
                this.addAll(this.fCreator.createFor((Binary)n));
            } else if (n instanceof Block) {
                this.addAll(this.fCreator.createFor((Block)n));
            } else if (n instanceof BooleanLit) {
                this.addAll(this.fCreator.createFor((BooleanLit)n));
            } else if (n instanceof Branch) {
                this.addAll(this.fCreator.createFor((Branch)n));
            } else if (n instanceof Call) {
                this.addAll(this.fCreator.createFor((Call)n));
            } else if (n instanceof CanonicalTypeNode) {
                this.addAll(this.fCreator.createFor((CanonicalTypeNode)n));
            } else if (n instanceof Case) {
                this.addAll(this.fCreator.createFor((Case)n));
            } else if (n instanceof Cast) {
                this.addAll(this.fCreator.createFor((Cast)n));
            } else if (n instanceof Catch) {
                this.addAll(this.fCreator.createFor((Catch)n));
            } else if (n instanceof CharLit) {
                this.addAll(this.fCreator.createFor((CharLit)n));
            } else if (n instanceof ClassBody) {
                this.addAll(this.fCreator.createFor((ClassBody)n));
            } else if (n instanceof ClassDecl) {
                this.addAll(this.fCreator.createFor((ClassDecl)n));
            } else if (n instanceof ClassLit) {
                this.addAll(this.fCreator.createFor((ClassLit)n));
            } else if (n instanceof Conditional) {
                this.addAll(this.fCreator.createFor((Conditional)n));
            } else if (n instanceof ConstructorCall) {
                this.addAll(this.fCreator.createFor((ConstructorCall)n));
            } else if (n instanceof ConstructorDecl) {
                this.addAll(this.fCreator.createFor((ConstructorDecl)n));
            } else if (n instanceof Do) {
                this.addAll(this.fCreator.createFor((Do)n));
            } else if (n instanceof Empty) {
                this.addAll(this.fCreator.createFor((Empty)n));
            } else if (n instanceof Eval) {
                this.addAll(this.fCreator.createFor((Eval)n));
            } else if (n instanceof Field) {
                this.addAll(this.fCreator.createFor((Field)n));
            } else if (n instanceof FieldAssign) {
                this.addAll(this.fCreator.createFor((FieldAssign)n));
            } else if (n instanceof FieldDecl) {
                this.addAll(this.fCreator.createFor((FieldDecl)n));
            } else if (n instanceof FloatLit) {
                this.addAll(this.fCreator.createFor((FloatLit)n));
            } else if (n instanceof For) {
                this.addAll(this.fCreator.createFor((For)n));
            } else if (n instanceof Formal) {
                this.addAll(this.fCreator.createFor((Formal)n));
            } else if (n instanceof If) {
                this.addAll(this.fCreator.createFor((If)n));
            } else if (n instanceof Import) {
                this.addAll(this.fCreator.createFor((Import)n));
            } else if (n instanceof Initializer) {
                this.addAll(this.fCreator.createFor((Initializer)n));
            } else if (n instanceof Instanceof) {
                this.addAll(this.fCreator.createFor((Instanceof)n));
            } else if (n instanceof IntLit) {
                this.addAll(this.fCreator.createFor((IntLit)n));
            } else if (n instanceof Labeled) {
                this.addAll(this.fCreator.createFor((Labeled)n));
            } else if (n instanceof Local) {
                this.addAll(this.fCreator.createFor((Local)n));
            } else if (n instanceof LocalAssign) {
                this.addAll(this.fCreator.createFor((LocalAssign)n));
            } else if (n instanceof LocalClassDecl) {
                this.addAll(this.fCreator.createFor((LocalClassDecl)n));
            } else if (n instanceof LocalDecl) {
                this.addAll(this.fCreator.createFor((LocalDecl)n));
            } else if (n instanceof MethodDecl) {
                this.addAll(this.fCreator.createFor((MethodDecl)n));
            } else if (n instanceof New) {
                this.addAll(this.fCreator.createFor((New)n));
            } else if (n instanceof NewArray) {
                this.addAll(this.fCreator.createFor((NewArray)n));
            } else if (n instanceof NullLit) {
                this.addAll(this.fCreator.createFor((NullLit)n));
            } else if (n instanceof NumLit) {
                this.addAll(this.fCreator.createFor((NumLit)n));
            } else if (n instanceof PackageNode) {
                this.addAll(this.fCreator.createFor((PackageNode)n));
            } else if (n instanceof Prefix) {
                this.addAll(this.fCreator.createFor((Prefix)n));
            } else if (n instanceof Return) {
                this.addAll(this.fCreator.createFor((Return)n));
            } else if (n instanceof SourceFile) {
                this.addAll(this.fCreator.createFor((SourceFile)n));
            } else if (n instanceof Special) {
                this.addAll(this.fCreator.createFor((Special)n));
            } else if (n instanceof StringLit) {
                this.addAll(this.fCreator.createFor((StringLit)n));
            } else if (n instanceof Switch) {
                this.addAll(this.fCreator.createFor((Switch)n));
            } else if (n instanceof SwitchBlock) {
                this.addAll(this.fCreator.createFor((SwitchBlock)n));
            } else if (n instanceof Synchronized) {
                this.addAll(this.fCreator.createFor((Synchronized)n));
            } else if (n instanceof Throw) {
                this.addAll(this.fCreator.createFor((Throw)n));
            } else if (n instanceof Try) {
                this.addAll(this.fCreator.createFor((Try)n));
            } else if (n instanceof Unary) {
                this.addAll(this.fCreator.createFor((Unary)n));
            } else if (n instanceof While) {
                this.addAll(this.fCreator.createFor((While)n));
            }
            return this;
        }
    }
}

