/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.util.KeyKind;
import org.eclipse.jdt.internal.core.util.KeyToSignature;

public class BindingKey {
    private String key;

    public BindingKey(String key) {
        this.key = key;
    }

    public static String createArrayTypeBindingKey(String typeKey, int arrayDimension) {
        StringBuffer buffer = new StringBuffer();
        while (arrayDimension-- > 0) {
            buffer.append('[');
        }
        buffer.append(typeKey);
        return buffer.toString();
    }

    public static String createParameterizedTypeBindingKey(String genericTypeKey, String[] argumentTypeKeys) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Signature.getTypeErasure((String)genericTypeKey));
        buffer.insert(buffer.length() - 1, '<');
        for (String argumentTypeKey : argumentTypeKeys) {
            buffer.insert(buffer.length() - 1, argumentTypeKey);
        }
        buffer.insert(buffer.length() - 1, '>');
        return buffer.toString();
    }

    public static String createTypeBindingKey(String typeName) {
        return Signature.createTypeSignature((String)typeName.replace('.', '/'), (boolean)true);
    }

    public static String createTypeVariableBindingKey(String typeVariableName, String declaringKey) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(declaringKey);
        buffer.append(':');
        buffer.append('T');
        buffer.append(typeVariableName);
        buffer.append(';');
        return buffer.toString();
    }

    public static String createWilcardTypeBindingKey(String typeKey, char kind) {
        switch (kind) {
            case '*': {
                return "*";
            }
            case '-': {
                return '-' + typeKey;
            }
            case '+': {
                return '+' + typeKey;
            }
        }
        return null;
    }

    public String[] getTypeArguments() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 1);
        keyToSignature.parse();
        return keyToSignature.getTypeArguments();
    }

    public boolean isRawType() {
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        return (kind.flags & 0x1001) != 0;
    }

    public boolean isParameterizedType() {
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        return (kind.flags & 0x1000) != 0;
    }

    public boolean isParameterizedMethod() {
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        return (kind.flags & 0x1011) != 0;
    }

    public String internalToSignature() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 0);
        keyToSignature.parse();
        return keyToSignature.signature.toString();
    }

    public String toString() {
        return this.key;
    }
}

