/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.actions.LanguageActionContributor;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GenerateSentenceAction
extends TextEditorAction {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;
    private final LPGParser.ASTNode fRoot;
    private final Set<LPGParser.nonTerm> fRecursiveSet = new HashSet<LPGParser.nonTerm>();
    private IParseController parseController;

    public GenerateSentenceAction(UniversalEditor editor) {
        super(LanguageActionContributor.ResBundle, "generateSentence.", (ITextEditor)editor);
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fRoot = this.getAST(editor);
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fRoot = null;
            this.fNode = null;
        }
    }

    public void run() {
        Object nt;
        UniversalEditor editor = (UniversalEditor)this.getTextEditor();
        this.parseController = editor.getParseController();
        if (this.fNode instanceof LPGParser.symWithAttrs1) {
            LPGParser.symWithAttrs1 sym = (LPGParser.symWithAttrs1)this.fNode;
            nt = ASTUtils.findDefOf(sym, (LPGParser.LPG)this.fRoot, this.parseController);
        } else if (this.fNode instanceof LPGParser.IASTNodeToken) {
            LPGParser.IASTNodeToken tok = (LPGParser.IASTNodeToken)((Object)this.fNode);
            nt = ASTUtils.findDefOf(tok, (LPGParser.LPG)this.fRoot, this.parseController);
        } else {
            nt = this.fNode;
        }
        if (!(nt instanceof LPGParser.nonTerm)) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Can only generate sentence for a non-terminal.");
            return;
        }
        LPGParser.nonTerm fNonTerm = (LPGParser.nonTerm)nt;
        String result = this.generateSentenceFor(fNonTerm);
        MessageDialog.openInformation((Shell)editor.getSite().getShell(), (String)"Sentence", (String)result);
    }

    private String generateSentenceFor(LPGParser.ASTNode node) {
        if (node instanceof LPGParser.nonTerm) {
            return this.generateSentenceFor((LPGParser.nonTerm)node);
        }
        if (node instanceof LPGParser.terminal) {
            LPGParser.terminal term = (LPGParser.terminal)node;
            return term.getLeftIToken().toString();
        }
        if (node instanceof LPGParser.IASTNodeToken) {
            String tokStr = ((LPGParser.IASTNodeToken)((Object)node)).toString();
            if (!tokStr.equals("$empty")) {
                return tokStr;
            }
            return "";
        }
        if (node instanceof LPGParser.rule) {
            return this.generateSentenceFor((LPGParser.rule)node);
        }
        return "??";
    }

    private String generateSentenceFor(LPGParser.nonTerm nonTerm2) {
        LPGParser.ruleList rhSides = nonTerm2.getruleList();
        StringBuffer buff = new StringBuffer();
        if (this.isRecursive(nonTerm2)) {
            if (!this.fRecursiveSet.contains(nonTerm2)) {
                this.fRecursiveSet.add(nonTerm2);
                buff.append(this.generateSentenceFor(this.findARecursiveCase(nonTerm2)));
            } else {
                buff.append(this.generateSentenceFor(this.findRootCase(nonTerm2)));
            }
        } else {
            buff.append(this.generateSentenceFor(rhSides.getElementAt(0)));
        }
        return buff.toString();
    }

    private String generateSentenceFor(LPGParser.rule rhsElem) {
        StringBuffer buff = new StringBuffer();
        LPGParser.symWithAttrsList symList = rhsElem.getsymWithAttrsList();
        for (int symIdx = 0; symIdx < symList.size(); ++symIdx) {
            LPGParser.IsymWithAttrs sym = symList.getsymWithAttrsAt(symIdx);
            Object def = ASTUtils.findDefOf(sym, (LPGParser.LPG)this.fRoot, this.parseController);
            if (def != null) {
                buff.append(this.generateSentenceFor((LPGParser.ASTNode)def));
            } else {
                buff.append(this.generateSentenceFor((LPGParser.ASTNode)((Object)sym)));
            }
            if (symIdx >= symList.size() - 1) continue;
            buff.append(' ');
        }
        return buff.toString();
    }

    private LPGParser.rule findRootCase(LPGParser.nonTerm nonTerm2) {
        String nonTermName = this.stripAnnotations(nonTerm2.getruleNameWithAttributes().getSYMBOL().toString());
        LPGParser.ruleList rhSides = nonTerm2.getruleList();
        for (int i = 0; i < rhSides.size(); ++i) {
            LPGParser.rule rhsElem = (LPGParser.rule)rhSides.getElementAt(i);
            LPGParser.symWithAttrsList symList = rhsElem.getsymWithAttrsList();
            boolean recursive = false;
            for (int j = 0; j < symList.size(); ++j) {
                LPGParser.IsymWithAttrs sym = symList.getsymWithAttrsAt(j);
                String symName = this.stripAnnotations(sym.getLeftIToken().toString());
                if (!symName.equals(nonTermName)) continue;
                recursive = true;
                break;
            }
            if (recursive) continue;
            return rhsElem;
        }
        return null;
    }

    private LPGParser.rule findARecursiveCase(LPGParser.nonTerm nonTerm2) {
        String nonTermName = this.stripAnnotations(nonTerm2.getruleNameWithAttributes().getSYMBOL().toString());
        LPGParser.ruleList rhSides = nonTerm2.getruleList();
        for (int i = 0; i < rhSides.size(); ++i) {
            LPGParser.rule rhsElem = (LPGParser.rule)rhSides.getElementAt(i);
            LPGParser.symWithAttrsList symList = rhsElem.getsymWithAttrsList();
            for (int j = 0; j < symList.size(); ++j) {
                LPGParser.IsymWithAttrs sym = symList.getsymWithAttrsAt(j);
                String symName = this.stripAnnotations(sym.getLeftIToken().toString());
                if (!symName.equals(nonTermName)) continue;
                return rhsElem;
            }
        }
        return null;
    }

    private String stripAnnotations(String symbol) {
        String result = symbol;
        while (result.lastIndexOf(36) >= 0) {
            result = result.substring(0, result.lastIndexOf(36));
        }
        return result;
    }

    private boolean isRecursive(LPGParser.nonTerm nonTerm2) {
        String nonTermName = this.stripAnnotations(nonTerm2.getruleNameWithAttributes().getSYMBOL().toString());
        LPGParser.ruleList rhSides = nonTerm2.getruleList();
        for (int i = 0; i < rhSides.size(); ++i) {
            LPGParser.rule rule2 = (LPGParser.rule)rhSides.getElementAt(i);
            LPGParser.symWithAttrsList symList = rule2.getsymWithAttrsList();
            for (int j = 0; j < symList.size(); ++j) {
                LPGParser.IsymWithAttrs sym = symList.getsymWithAttrsAt(j);
                String symName = this.stripAnnotations(sym.getLeftIToken().toString());
                if (!symName.equals(nonTermName)) continue;
                return true;
            }
        }
        return false;
    }

    private LPGParser.ASTNode getAST(UniversalEditor editor) {
        IParseController parseController = editor.getParseController();
        return (LPGParser.ASTNode)parseController.getCurrentAst();
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        ISourcePositionLocator locator = parseController.getSourcePositionLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)this.fRoot, sel.x);
    }
}

