/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import lpg.runtime.IToken;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.widgets.Display;

public class TokenColorer
implements ITokenColorer {
    static TextAttribute COMMENT;
    static TextAttribute SYMBOL;
    static TextAttribute KEYWORD;
    static TextAttribute LITERAL;
    static TextAttribute EMPTY;
    static TextAttribute ANNOTATION;

    public TokenColorer() {
        Display display = Display.getCurrent();
        COMMENT = new TextAttribute(display.getSystemColor(14), null, 2);
        SYMBOL = new TextAttribute(display.getSystemColor(4), null, 0);
        KEYWORD = new TextAttribute(display.getSystemColor(9), null, 1);
        EMPTY = new TextAttribute(display.getSystemColor(16), null, 1);
        LITERAL = new TextAttribute(display.getSystemColor(16), null, 2);
        ANNOTATION = new TextAttribute(display.getSystemColor(11), null, 2);
    }

    public TextAttribute getColoring(IParseController controller, Object o) {
        IToken token = (IToken)o;
        if (token.getKind() == 12) {
            return EMPTY;
        }
        if (((SimpleLPGParseController)controller).isKeyword(token.getKind())) {
            return KEYWORD;
        }
        if (token.getKind() == 1) {
            int tokStartOffset = token.getStartOffset();
            char ch = ((SimpleLPGParseController)controller).getParser().getIPrsStream().getInputChars()[tokStartOffset];
            if (ch == '\'' || ch == '\"') {
                return LITERAL;
            }
            return SYMBOL;
        }
        if (token.getKind() == 44) {
            return COMMENT;
        }
        if (token.getKind() == 2) {
            return ANNOTATION;
        }
        return null;
    }

    public IRegion calculateDamageExtent(IRegion seed, IParseController ctlr) {
        return seed;
    }
}

