/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.UnsupportedEncodingException;

public class SourceDebugExtensionWriter
extends ClassWriter.Element {
    private final int attrID;
    private byte[] table;

    public SourceDebugExtensionWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("SourceDebugExtension");
    }

    public int getSize() {
        return this.table == null ? 6 : 6 + this.table.length;
    }

    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, this.getSize() - 6);
        offset += 6;
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                ClassWriter.setUByte(buf, offset, this.table[i]);
                ++offset;
            }
        }
        return offset;
    }

    public void setRawTable(byte[] sourceDebug) {
        if (sourceDebug == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        for (int i = 0; i < sourceDebug.length; ++i) {
            if (sourceDebug[i] >= 1) continue;
            throw new IllegalArgumentException("Invalid CP index: " + sourceDebug[i]);
        }
        this.table = sourceDebug;
    }

    public void setDebugInfo(String sourceDebug) {
        if (sourceDebug == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        try {
            byte[] bytes = sourceDebug.getBytes("UTF8");
            this.setRawTable(bytes);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
    }
}

