/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.imp.analysis.reachingdefs.DefinitionLiteral;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsEntry;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsExit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class ReachingDefsVariableFactory {
    private IVarNodeToLiteral fVarMap = new VarNodeToLiteral();
    private Map<ASTNode, ReachingDefsEntry> fEntryMap = new LinkedHashMap<ASTNode, ReachingDefsEntry>();
    private Map<ASTNode, ReachingDefsExit> fExitMap = new LinkedHashMap<ASTNode, ReachingDefsExit>();

    public DefinitionLiteral createDefinitionLiteral(IVariableBinding var, ASTNode label) {
        DefinitionLiteral d;
        LinkedHashMap<ASTNode, DefinitionLiteral> label2DefLit = (LinkedHashMap<ASTNode, DefinitionLiteral>)this.fVarMap.get(var);
        if (label2DefLit == null) {
            label2DefLit = new LinkedHashMap<ASTNode, DefinitionLiteral>();
            this.fVarMap.put(var, label2DefLit);
        }
        if ((d = (DefinitionLiteral)label2DefLit.get(label)) == null) {
            d = new DefinitionLiteral(var, label);
            label2DefLit.put(label, d);
        }
        return d;
    }

    public ReachingDefsEntry createEntryLabel(ASTNode node) {
        ReachingDefsEntry e = this.fEntryMap.get(node);
        if (e == null) {
            e = new ReachingDefsEntry(node);
            this.fEntryMap.put(node, e);
        }
        return e;
    }

    public ReachingDefsExit createExitLabel(ASTNode node) {
        ReachingDefsExit e = this.fExitMap.get(node);
        if (e == null) {
            e = new ReachingDefsExit(node);
            this.fExitMap.put(node, e);
        }
        return e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VarNodeToLiteral
    extends LinkedHashMap<IVariableBinding, Map<ASTNode, DefinitionLiteral>>
    implements IVarNodeToLiteral {
        private VarNodeToLiteral() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IVarNodeToLiteral
    extends Map<IVariableBinding, Map<ASTNode, DefinitionLiteral>> {
    }
}

