/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalValue
implements IReal {
    private static final Type DOUBLE_TYPE = TypeFactory.getInstance().realType();
    protected final BigDecimal value;

    protected BigDecimalValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public Type getType() {
        return DOUBLE_TYPE;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public IInteger toInteger() {
        return ValueFactory.getInstance().integer(this.value.toBigInteger());
    }

    @Override
    public IReal floor() {
        return ValueFactory.getInstance().real(this.value.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public IReal round() {
        return ValueFactory.getInstance().real(this.value.setScale(0, RoundingMode.HALF_UP));
    }

    @Override
    public IReal add(IReal other) {
        return ValueFactory.getInstance().real(this.value.add(((BigDecimalValue)other).value));
    }

    @Override
    public IReal subtract(IReal other) {
        return ValueFactory.getInstance().real(this.value.subtract(((BigDecimalValue)other).value));
    }

    @Override
    public IReal multiply(IReal other) {
        return ValueFactory.getInstance().real(this.value.multiply(((BigDecimalValue)other).value));
    }

    @Override
    public IReal divide(IReal other, int precision) {
        return ValueFactory.getInstance().real(this.value.divide(((BigDecimalValue)other).value));
    }

    @Override
    public IReal negate() {
        return ValueFactory.getInstance().real(this.value.negate());
    }

    @Override
    public int precision() {
        return this.value.precision();
    }

    @Override
    public int scale() {
        return this.value.scale();
    }

    @Override
    public IInteger unscaled() {
        return ValueFactory.getInstance().integer(this.value.unscaledValue());
    }

    @Override
    public IBool greater(IReal other) {
        return ValueFactory.getInstance().bool(this.compare(other) > 0);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return ValueFactory.getInstance().bool(this.compare(other) >= 0);
    }

    @Override
    public IBool less(IReal other) {
        return ValueFactory.getInstance().bool(this.compare(other) < 0);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return ValueFactory.getInstance().bool(this.compare(other) <= 0);
    }

    @Override
    public int compare(IReal other) {
        return this.value.compareTo(((BigDecimalValue)other).value);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitReal(this);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value.doubleValue());
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            BigDecimalValue otherDouble = (BigDecimalValue)o;
            return this.value.compareTo(otherDouble.value) == 0;
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        return this.equals(value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String stringRepresentation = this.value.toString();
        sb.append(stringRepresentation);
        if (stringRepresentation.indexOf(".") == -1) {
            sb.append(".0");
        }
        return sb.toString();
    }

    @Override
    public String getStringRepresentation() {
        return this.toString();
    }
}

