/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Map;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashMap;
import org.eclipse.imp.pdb.facts.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapWriter
implements IMapWriter {
    protected final Type keyType;
    protected final Type valueType;
    protected final ShareableValuesHashMap data;
    protected IMap constructedMap;

    protected MapWriter(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.data = new ShareableValuesHashMap();
        this.constructedMap = null;
    }

    protected MapWriter(Type keyType, Type valueType, ShareableValuesHashMap data) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.data = data;
        this.constructedMap = null;
    }

    @Override
    public void put(IValue key, IValue value) {
        this.checkMutation();
        this.data.put(key, value);
    }

    @Override
    public void putAll(IMap map) {
        this.checkMutation();
        Iterator<Map.Entry<IValue, IValue>> entryIterator = map.entryIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            this.data.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(java.util.Map<IValue, IValue> map) {
        this.checkMutation();
        for (Map.Entry<IValue, IValue> entry : map.entrySet()) {
            this.data.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void insert(IValue ... values) {
        this.checkMutation();
        for (int i = values.length - 1; i >= 0; --i) {
            IValue value = values[i];
            if (!(value instanceof ITuple)) {
                throw new IllegalArgumentException("Argument must be of ITuple type.");
            }
            ITuple tuple = (ITuple)value;
            if (tuple.arity() != 2) {
                throw new IllegalArgumentException("Tuple must have an arity of 2.");
            }
            this.put(tuple.get(0), tuple.get(1));
        }
    }

    @Override
    public void insertAll(Iterable<IValue> collection) {
        this.checkMutation();
        for (IValue value : collection) {
            if (!(value instanceof ITuple)) {
                throw new IllegalArgumentException("Argument must be of ITuple type.");
            }
            ITuple tuple = (ITuple)value;
            if (tuple.arity() != 2) {
                throw new IllegalArgumentException("Tuple must have an arity of 2.");
            }
            this.put(tuple.get(0), tuple.get(1));
        }
    }

    protected void checkMutation() {
        if (this.constructedMap != null) {
            throw new UnsupportedOperationException("Mutation of a finalized map is not supported.");
        }
    }

    @Override
    public IMap done() {
        if (this.constructedMap == null) {
            this.constructedMap = new Map(this.keyType, this.valueType, this.data);
        }
        return this.constructedMap;
    }
}

