/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Relation;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationWriter
implements IRelationWriter {
    protected final Type tupleType;
    protected final ShareableValuesHashSet data;
    protected IRelation constructedRelation;

    protected RelationWriter(Type tupleType) {
        this.tupleType = tupleType;
        this.data = new ShareableValuesHashSet();
        this.constructedRelation = null;
    }

    protected RelationWriter(Type tupleType, ShareableValuesHashSet data) {
        this.tupleType = tupleType;
        this.data = new ShareableValuesHashSet(data);
        this.constructedRelation = null;
    }

    public void insert(IValue element) {
        this.checkMutation();
        this.data.add(element);
    }

    @Override
    public void insert(IValue ... elements) {
        this.checkMutation();
        for (int i = elements.length - 1; i >= 0; --i) {
            this.data.add(elements[i]);
        }
    }

    @Override
    public void insertAll(Iterable<IValue> collection) {
        this.checkMutation();
        Iterator<IValue> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            this.data.add(collectionIterator.next());
        }
    }

    @Override
    public void delete(IValue element) {
        this.checkMutation();
        this.data.remove(element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    protected void checkMutation() {
        if (this.constructedRelation != null) {
            throw new UnsupportedOperationException("Mutation of a finalized map is not supported.");
        }
    }

    @Override
    public IRelation done() {
        if (this.constructedRelation == null) {
            this.constructedRelation = new Relation(this.tupleType, this.data);
        }
        return this.constructedRelation;
    }
}

