/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.math.BigInteger;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.impl.ICanBecomeABigInteger;
import org.eclipse.imp.pdb.facts.impl.fast.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedBigIntegerValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;

public class SharedIntegerValue
extends IntegerValue
implements IShareable {
    protected SharedIntegerValue(int value) {
        super(value);
    }

    public IReal toReal() {
        return SharedValueFactory.getInstance().real(this.value);
    }

    public IInteger add(IInteger other) {
        if (other instanceof SharedBigIntegerValue) {
            return other.add(this);
        }
        int otherIntValue = other.intValue();
        int result = this.value + otherIntValue;
        if (this.value < 0 && otherIntValue < 0 && result >= 0) {
            byte[] intValueData = new byte[]{-1, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return SharedValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        if (this.value > 0 && otherIntValue > 0 && result < 0) {
            byte[] intValueData = new byte[]{0, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return SharedValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger subtract(IInteger other) {
        if (other instanceof SharedBigIntegerValue) {
            return other.subtract(this.negate());
        }
        int otherIntValue = other.intValue();
        int result = this.value - otherIntValue;
        if (this.value < 0 && otherIntValue > 0 && result > 0) {
            byte[] intValueData = new byte[]{-1, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return SharedValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        if (this.value > 0 && otherIntValue < 0 && result < 0) {
            byte[] intValueData = new byte[]{0, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return SharedValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger multiply(IInteger other) {
        boolean resultIsPositive;
        if (this.value == 0) {
            return this;
        }
        if (other instanceof SharedBigIntegerValue) {
            return other.multiply(this);
        }
        int otherIntValue = other.intValue();
        if (otherIntValue == 0) {
            return other;
        }
        boolean bl = resultIsPositive = ((this.value ^ otherIntValue ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (resultIsPositive) {
            int div = Integer.MAX_VALUE / otherIntValue;
            if (this.value > 0 ? this.value <= div : this.value >= div) {
                return SharedValueFactory.getInstance().integer(this.value * other.intValue());
            }
        } else {
            int div = Integer.MIN_VALUE / otherIntValue;
            if (this.value > 0 ? this.value <= div : this.value >= div) {
                return SharedValueFactory.getInstance().integer(this.value * other.intValue());
            }
        }
        return SharedValueFactory.getInstance().integer(this.toBigInteger().multiply(((ICanBecomeABigInteger)((Object)other)).toBigInteger()));
    }

    public IInteger divide(IInteger other) {
        if (other instanceof SharedBigIntegerValue) {
            return SharedValueFactory.getInstance().integer(this.toBigInteger().divide(((ICanBecomeABigInteger)((Object)other)).toBigInteger()));
        }
        return SharedValueFactory.getInstance().integer(this.value / other.intValue());
    }

    public IInteger mod(IInteger other) {
        if (other instanceof SharedBigIntegerValue) {
            if (this.value < 0) {
                return SharedValueFactory.getInstance().integer(~this.value + 1);
            }
            return this;
        }
        int newValue = this.value % other.intValue();
        newValue = newValue >= 0 ? newValue : ~newValue + 1;
        return SharedValueFactory.getInstance().integer(newValue);
    }

    public IInteger remainder(IInteger other) {
        if (other instanceof SharedBigIntegerValue) {
            return this;
        }
        return SharedValueFactory.getInstance().integer(this.value % other.intValue());
    }

    public IInteger negate() {
        return SharedValueFactory.getInstance().integer(~this.value + 1);
    }

    public IBool greater(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) > 0);
    }

    public IBool greaterEqual(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) >= 0);
    }

    public IBool less(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) < 0);
    }

    public IBool lessEqual(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) <= 0);
    }

    public int compare(IInteger other) {
        if (other instanceof SharedBigIntegerValue) {
            return ~other.compare(this);
        }
        if (this.value > other.intValue()) {
            return 1;
        }
        if (this.value < other.intValue()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.value ^ this.value << 27;
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

