/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Map;
import org.eclipse.imp.pdb.facts.impl.shared.SharedMapWriter;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashMap;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.type.Type;

public class SharedMap
extends Map
implements IShareable {
    protected SharedMap(Type keyType, Type valueType, ShareableValuesHashMap data) {
        super(keyType, valueType, data);
    }

    public IMap put(IValue key, IValue value) {
        ShareableValuesHashMap newData = new ShareableValuesHashMap(this.data);
        newData.put(key, value);
        Type newKeyType = this.keyType.lub(key.getType());
        Type newValueType = this.valueType.lub(value.getType());
        return new SharedMapWriter(newKeyType, newValueType, newData).done();
    }

    public IMap common(IMap other) {
        IMap theOtherMap;
        Iterator<Map.Entry<IValue, IValue>> entryIterator;
        ShareableValuesHashMap commonData = new ShareableValuesHashMap();
        if (other.size() < this.size()) {
            entryIterator = other.entryIterator();
            theOtherMap = this;
        } else {
            entryIterator = this.entryIterator();
            theOtherMap = other;
        }
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            IValue key = entry.getKey();
            IValue value = entry.getValue();
            if (!value.isEqual(theOtherMap.get(key))) continue;
            commonData.put(key, value);
        }
        Type newKeyType = this.keyType.lub(other.getKeyType());
        Type newValueType = this.valueType.lub(other.getValueType());
        return new SharedMapWriter(newKeyType, newValueType, commonData).done();
    }

    public IMap join(IMap other) {
        Iterator<Map.Entry<IValue, IValue>> entryIterator;
        ShareableValuesHashMap newData;
        SharedMap otherMap = (SharedMap)other;
        if (otherMap.size() < this.size()) {
            newData = new ShareableValuesHashMap(this.data);
            entryIterator = otherMap.entryIterator();
        } else {
            newData = new ShareableValuesHashMap(otherMap.data);
            entryIterator = this.entryIterator();
        }
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            newData.put(entry.getKey(), entry.getValue());
        }
        Type newKeyType = this.keyType.lub(otherMap.keyType);
        Type newValueType = this.valueType.lub(otherMap.valueType);
        return new SharedMapWriter(newKeyType, newValueType, newData).done();
    }

    public IMap remove(IMap other) {
        ShareableValuesHashMap newData = new ShareableValuesHashMap(this.data);
        Iterator<IValue> keysIterator = other.iterator();
        while (keysIterator.hasNext()) {
            newData.remove(keysIterator.next());
        }
        return new SharedMapWriter(this.keyType, this.valueType, newData).done();
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

