/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Set;
import org.eclipse.imp.pdb.facts.impl.shared.SharedRelationWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedSetWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.type.Type;

public class SharedSet
extends Set
implements IShareable {
    protected SharedSet(Type elementType, ShareableValuesHashSet data) {
        super(elementType, data);
    }

    protected SharedSet(Type subTypeOfSet, Type elementType, ShareableValuesHashSet data) {
        super(subTypeOfSet, elementType, data);
    }

    public ISet insert(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.add(value);
        Type newElementType = this.elementType.lub(value.getType());
        return SharedSet.createSetWriter(newElementType, newData).done();
    }

    public ISet delete(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.remove(value);
        return SharedSet.createSetWriter(this.elementType, newData).done();
    }

    public ISet intersect(ISet other) {
        ISet theOtherSet;
        Iterator<Object> setIterator;
        ShareableValuesHashSet commonData = new ShareableValuesHashSet();
        if (other.size() < this.size()) {
            setIterator = other.iterator();
            theOtherSet = this;
        } else {
            setIterator = this.iterator();
            theOtherSet = other;
        }
        while (setIterator.hasNext()) {
            IValue value = (IValue)setIterator.next();
            if (!theOtherSet.contains(value)) continue;
            commonData.add(value);
        }
        Type newElementType = this.elementType.lub(other.getElementType());
        return SharedSet.createSetWriter(newElementType, commonData).done();
    }

    public ISet subtract(ISet other) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        Iterator setIterator = other.iterator();
        while (setIterator.hasNext()) {
            newData.remove(setIterator.next());
        }
        return SharedSet.createSetWriter(this.elementType, newData).done();
    }

    public ISet union(ISet other) {
        Iterator<IValue> setIterator;
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        SharedSet otherSet = (SharedSet)other;
        if (otherSet.size() < this.size()) {
            newData = new ShareableValuesHashSet(this.data);
            setIterator = otherSet.iterator();
        } else {
            newData = new ShareableValuesHashSet(otherSet.data);
            setIterator = this.iterator();
        }
        while (setIterator.hasNext()) {
            newData.add(setIterator.next());
        }
        Type newElementType = this.elementType.lub(otherSet.elementType);
        return SharedSet.createSetWriter(newElementType, newData).done();
    }

    public IRelation product(ISet other) {
        SharedValueFactory sharedValueFactory = SharedValueFactory.getInstance();
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        Type tupleType = typeFactory.tupleType(this.elementType, other.getElementType());
        for (IValue left : this.data) {
            for (IValue right : other) {
                IValue[] tuple = new IValue[]{left, right};
                newData.add(sharedValueFactory.createTupleUnsafe(tupleType, tuple));
            }
        }
        return new SharedRelationWriter(tupleType, newData).done();
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    protected static ISetWriter createSetWriter(Type elementType, ShareableValuesHashSet data) {
        if (elementType.isTupleType()) {
            return new SharedRelationWriter(elementType, data);
        }
        return new SharedSetWriter(elementType, data);
    }
}

