/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredAbstractDataTypeException;
import org.eclipse.imp.pdb.facts.io.AbstractReader;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

public class ATermReader
extends AbstractReader {
    private IValueFactory vf;
    private TypeFactory tf = TypeFactory.getInstance();
    private TypeStore ts;

    public IValue read(IValueFactory factory, TypeStore store, Type type, InputStream stream) throws FactParseError, IOException {
        int firstToken;
        this.vf = factory;
        this.ts = store;
        do {
            if ((firstToken = stream.read()) != -1) continue;
            throw new IOException("Premature EOF.");
        } while (Character.isWhitespace((char)firstToken));
        char typeByte = (char)firstToken;
        if (typeByte == '!') {
            SharingStream sreader = new SharingStream(stream);
            sreader.initializeSharing();
            sreader.readSkippingWS();
            return this.parse(sreader, type);
        }
        if (typeByte == '?') {
            throw new UnsupportedOperationException("nyi");
        }
        if (Character.isLetterOrDigit(typeByte) || typeByte == '_' || typeByte == '[' || typeByte == '-') {
            SharingStream sreader = new SharingStream(stream);
            sreader.last_char = typeByte;
            return this.parse(sreader, type);
        }
        throw new RuntimeException("nyi");
    }

    private IValue parse(SharingStream reader, Type expected) throws IOException {
        IValue result;
        int start = reader.getPosition();
        switch (reader.getLastChar()) {
            case -1: {
                throw new FactParseError("premature EOF encountered.", start);
            }
            case 35: {
                return this.parseAbbrev(reader);
            }
            case 91: {
                result = this.parseList(reader, expected);
                break;
            }
            case 60: {
                throw new FactParseError("Placeholders are not supported", start);
            }
            case 34: {
                result = this.parseString(reader, expected);
                break;
            }
            case 40: {
                result = this.parseTuple(reader, expected);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                result = this.parseNumber(reader, expected);
                break;
            }
            default: {
                result = this.parseAppl(reader, expected);
            }
        }
        if (reader.getLastChar() == 123) {
            result = this.parseAnnotations(reader, result);
        }
        int end = reader.getPosition();
        reader.storeNextTerm(result, end - start);
        return result;
    }

    private IValue parseAnnotations(SharingStream reader, IValue result) throws IOException {
        if (reader.readSkippingWS() == 125) {
            reader.readSkippingWS();
        } else {
            result = this.parseAnnos(reader, result);
            if (reader.getLastChar() != 125) {
                throw new FactParseError("'}' expected", reader.getPosition());
            }
        }
        return result;
    }

    private IValue parseAppl(SharingStream reader, Type expected) throws IOException {
        IValue result;
        int c = reader.getLastChar();
        if (Character.isLetter(c)) {
            Type node;
            String funname = this.parseId(reader);
            if (expected.isAbstractDataType()) {
                Set<Type> nodes = this.ts.lookupConstructor(expected, funname);
                Iterator<Type> iterator = nodes.iterator();
                if (!iterator.hasNext()) {
                    throw new UndeclaredAbstractDataTypeException(expected);
                }
                node = iterator.next();
            } else {
                node = expected;
            }
            c = reader.skipWS();
            if (reader.getLastChar() == 40) {
                c = reader.readSkippingWS();
                if (c == -1) {
                    throw new FactParseError("premature EOF encountered.", reader.getPosition());
                }
                if (reader.getLastChar() == 41) {
                    result = this.vf.constructor(node, new IValue[0]);
                } else {
                    IValue[] list = expected.isAbstractDataType() ? this.parseFixedSizeATermsArray(reader, node.getFieldTypes()) : this.parseATermsArray(reader, TypeFactory.getInstance().valueType());
                    if (reader.getLastChar() != 41) {
                        throw new FactParseError("expected ')' but got '" + (char)reader.getLastChar() + "'", reader.getPosition());
                    }
                    result = expected.isAbstractDataType() ? node.make(this.vf, list) : node.make(this.vf, funname, list);
                }
                c = reader.readSkippingWS();
            } else {
                result = node.isAbstractDataType() || node.isConstructorType() ? node.make(this.vf) : this.tf.nodeType().make(this.vf, funname);
            }
        } else {
            throw new FactParseError("illegal character: " + (char)reader.getLastChar(), reader.getPosition());
        }
        return result;
    }

    private IValue parseTuple(SharingStream reader, Type expected) throws IOException {
        IValue result;
        int c = reader.readSkippingWS();
        if (c == -1) {
            throw new FactParseError("premature EOF encountered.", reader.getPosition());
        }
        if (reader.getLastChar() == 41) {
            result = expected.make(this.vf);
        } else {
            IValue[] list = this.parseFixedSizeATermsArray(reader, expected);
            if (reader.getLastChar() != 41) {
                throw new FactParseError("expected ')' but got '" + (char)reader.getLastChar() + "'", reader.getPosition());
            }
            result = expected.make(this.vf, list);
        }
        c = reader.readSkippingWS();
        return result;
    }

    private IValue parseString(SharingStream reader, Type expected) throws IOException {
        String str = this.parseStringLiteral(reader);
        IValue result = expected.make(this.vf, str);
        int c = reader.readSkippingWS();
        if (c == -1) {
            throw new FactParseError("premature EOF encountered.", reader.getPosition());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IValue parseList(SharingStream reader, Type expected) throws IOException {
        int c = reader.readSkippingWS();
        if (c == -1) {
            throw new FactParseError("premature EOF encountered.", reader.getPosition());
        }
        if (c == 93) {
            c = reader.readSkippingWS();
            if (expected.isListType()) {
                return expected.make(this.vf);
            }
            if (!expected.isValueType()) throw new FactParseError("Did not expect a list, rather a " + expected, reader.getPosition());
            return this.tf.listType(this.tf.valueType()).make(this.vf);
        }
        IValue result = this.parseATerms(reader, expected);
        if (reader.getLastChar() != 93) {
            throw new FactParseError("expected ']' but got '" + (char)reader.getLastChar() + "'", reader.getPosition());
        }
        c = reader.readSkippingWS();
        return result;
    }

    private IValue parseAnnos(SharingStream reader, IValue result) throws IOException {
        result = this.parseAnno(reader, result);
        while (reader.getLastChar() == 44) {
            reader.readSkippingWS();
            result = this.parseAnno(reader, result);
        }
        return result;
    }

    private IValue parseAnno(SharingStream reader, IValue result) throws IOException {
        if (reader.getLastChar() == 91) {
            int c = reader.readSkippingWS();
            if (c == 34) {
                String key = this.parseStringLiteral(reader);
                Type annoType = this.ts.getAnnotationType(result.getType(), key);
                if (reader.readSkippingWS() == 44) {
                    reader.readSkippingWS();
                    IValue value = this.parse(reader, annoType);
                    if (result.getType().isConstructorType() || result.getType().isAbstractDataType()) {
                        result = ((IConstructor)result).setAnnotation(key, value);
                    }
                    if (reader.getLastChar() != 93) {
                        throw new FactParseError("expected a ] but got a " + reader.getLastChar(), reader.getPosition());
                    }
                    reader.readSkippingWS();
                    return result;
                }
                throw new FactParseError("expected a comma before the value of the annotation", reader.getPosition());
            }
            throw new FactParseError("expected a label for an annotation", reader.getPosition());
        }
        return result;
    }

    private static boolean isBase64(int c) {
        return Character.isLetterOrDigit(c) || c == 43 || c == 47;
    }

    private IValue parseAbbrev(SharingStream reader) throws IOException {
        int c = reader.read();
        int abbrev = 0;
        while (ATermReader.isBase64(c)) {
            abbrev *= 64;
            if (c >= 65 && c <= 90) {
                abbrev += c - 65;
            } else if (c >= 97 && c <= 122) {
                abbrev += c - 97 + 26;
            } else if (c >= 48 && c <= 57) {
                abbrev += c - 48 + 52;
            } else if (c == 43) {
                abbrev += 62;
            } else if (c == 47) {
                abbrev += 63;
            } else {
                throw new RuntimeException("not a base-64 digit: " + c);
            }
            c = reader.read();
        }
        IValue result = reader.getTerm(abbrev);
        return result;
    }

    private IValue parseNumber(SharingStream reader, Type expected) throws IOException {
        IValue result;
        StringBuilder str = new StringBuilder();
        do {
            str.append((char)reader.getLastChar());
        } while (Character.isDigit(reader.read()));
        if (reader.getLastChar() != 46 && reader.getLastChar() != 101 && reader.getLastChar() != 69 && reader.getLastChar() != 108 && reader.getLastChar() != 76) {
            int val;
            try {
                val = Integer.parseInt(str.toString());
            }
            catch (NumberFormatException e) {
                throw new FactParseError("malformed int:" + str, reader.getPosition());
            }
            result = expected.make(this.vf, this.ts, val);
        } else {
            if (reader.getLastChar() == 108 || reader.getLastChar() == 76) {
                reader.read();
                throw new FactParseError("No support for longs", reader.getPosition());
            }
            if (reader.getLastChar() == 46) {
                str.append('.');
                reader.read();
                if (!Character.isDigit(reader.getLastChar())) {
                    throw new FactParseError("digit expected", reader.getPosition());
                }
                do {
                    str.append((char)reader.getLastChar());
                } while (Character.isDigit(reader.read()));
            }
            if (reader.getLastChar() == 101 || reader.getLastChar() == 69) {
                str.append((char)reader.getLastChar());
                reader.read();
                if (reader.getLastChar() == 45 || reader.getLastChar() == 43) {
                    str.append((char)reader.getLastChar());
                    reader.read();
                }
                if (!Character.isDigit(reader.getLastChar())) {
                    throw new FactParseError("digit expected!", reader.getPosition());
                }
                do {
                    str.append((char)reader.getLastChar());
                } while (Character.isDigit(reader.read()));
            }
            try {
                double val = Double.valueOf(str.toString());
                result = expected.make(this.vf, this.ts, val);
            }
            catch (NumberFormatException e) {
                throw new FactParseError("malformed real", reader.getPosition(), e);
            }
        }
        reader.skipWS();
        return result;
    }

    private String parseId(SharingStream reader) throws IOException {
        int c = reader.getLastChar();
        StringBuilder buf = new StringBuilder(32);
        do {
            buf.append((char)c);
        } while (Character.isLetterOrDigit(c = reader.read()) || c == 95 || c == 45 || c == 43 || c == 42 || c == 36 || c == 46);
        return buf.toString();
    }

    private String parseStringLiteral(SharingStream reader) throws IOException {
        boolean escaped;
        StringBuilder str = new StringBuilder();
        do {
            int lastChar;
            escaped = false;
            if (reader.read() == 92) {
                reader.read();
                escaped = true;
            }
            if ((lastChar = reader.getLastChar()) == -1) {
                throw new IOException("Premature EOF.");
            }
            if (escaped) {
                switch (lastChar) {
                    case 110: {
                        str.append('\n');
                        break;
                    }
                    case 116: {
                        str.append('\t');
                        break;
                    }
                    case 98: {
                        str.append('\b');
                        break;
                    }
                    case 114: {
                        str.append('\r');
                        break;
                    }
                    case 102: {
                        str.append('\f');
                        break;
                    }
                    case 92: {
                        str.append('\\');
                        break;
                    }
                    case 39: {
                        str.append('\'');
                        break;
                    }
                    case 34: {
                        str.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        str.append(reader.readOct());
                        break;
                    }
                    default: {
                        str.append('\\').append((char)lastChar);
                        break;
                    }
                }
                continue;
            }
            if (lastChar == 34) continue;
            str.append((char)lastChar);
        } while (escaped || reader.getLastChar() != 34);
        return str.toString();
    }

    private IValue parseATerms(SharingStream reader, Type expected) throws IOException {
        Type base = expected;
        Type elementType = this.getElementType(expected);
        IValue[] terms = this.parseATermsArray(reader, elementType);
        if (base.isListType() || base.isValueType()) {
            IListWriter w = (IListWriter)expected.writer(this.vf);
            for (int i = terms.length - 1; i >= 0; --i) {
                w.insert(terms[i]);
            }
            return w.done();
        }
        if (base.isSetType()) {
            ISetWriter w = (ISetWriter)expected.writer(this.vf);
            w.insert(terms);
            return w.done();
        }
        if (base.isMapType()) {
            IMapWriter w = (IMapWriter)expected.writer(this.vf);
            for (IValue elem : terms) {
                ITuple tuple = (ITuple)elem;
                w.put(tuple.get(0), tuple.get(1));
            }
            return w.done();
        }
        if (base.isRelationType()) {
            ISetWriter w = (ISetWriter)expected.writer(this.vf);
            w.insert(terms);
            return w.done();
        }
        throw new FactParseError("Unexpected type " + expected, reader.getPosition());
    }

    private Type getElementType(Type expected) {
        Type base = expected;
        if (base.isListType()) {
            return base.getElementType();
        }
        if (base.isSetType()) {
            return base.getElementType();
        }
        if (base.isMapType()) {
            return this.tf.tupleType(base.getKeyType(), base.getValueType());
        }
        if (base.isRelationType()) {
            return base.getFieldTypes();
        }
        if (base.isValueType()) {
            return base;
        }
        throw new IllegalOperationException("getElementType", expected);
    }

    private IValue[] parseATermsArray(SharingStream reader, Type elementType) throws IOException {
        ArrayList<IValue> list = new ArrayList<IValue>();
        IValue term = this.parse(reader, elementType);
        list.add(term);
        while (reader.getLastChar() == 44) {
            reader.readSkippingWS();
            term = this.parse(reader, elementType);
            list.add(term);
        }
        IValue[] array = new IValue[list.size()];
        ListIterator iter = list.listIterator();
        int index = 0;
        while (iter.hasNext()) {
            array[index++] = (IValue)iter.next();
        }
        return array;
    }

    private IValue[] parseFixedSizeATermsArray(SharingStream reader, Type elementTypes) throws IOException {
        ArrayList<IValue> list = new ArrayList<IValue>();
        int i = 0;
        Type elementType = elementTypes.getFieldType(i++);
        IValue term = this.parse(reader, elementType);
        list.add(term);
        while (reader.getLastChar() == 44) {
            elementType = elementTypes.getFieldType(i++);
            reader.readSkippingWS();
            term = this.parse(reader, elementType);
            list.add(term);
        }
        IValue[] array = new IValue[list.size()];
        ListIterator iter = list.listIterator();
        int index = 0;
        while (iter.hasNext()) {
            array[index++] = (IValue)iter.next();
        }
        return array;
    }

    class SharingStream {
        private static final int INITIAL_TABLE_SIZE = 2048;
        private static final int TABLE_INCREMENT = 4096;
        private static final int INITIAL_BUFFER_SIZE = 1024;
        private InputStream reader;
        int last_char;
        private int pos;
        private int nr_terms;
        private IValue[] table;
        private byte[] buffer;
        private int limit;
        private int bufferPos;

        public SharingStream(InputStream reader) {
            this(reader, 1024);
        }

        public SharingStream(InputStream stream, int bufferSize) {
            this.reader = stream;
            this.last_char = -1;
            this.pos = 0;
            this.buffer = bufferSize < 1024 ? new byte[bufferSize] : new byte[1024];
            this.limit = -1;
            this.bufferPos = -1;
        }

        public void initializeSharing() {
            this.table = new IValue[2048];
            this.nr_terms = 0;
        }

        public void storeNextTerm(IValue t, int size) {
            if (this.table == null) {
                return;
            }
            if (this.nr_terms == this.table.length) {
                IValue[] new_table = new IValue[this.table.length + 4096];
                System.arraycopy(this.table, 0, new_table, 0, this.table.length);
                this.table = new_table;
            }
            this.table[this.nr_terms++] = t;
        }

        public IValue getTerm(int index) {
            if (index < 0 || index >= this.nr_terms) {
                throw new RuntimeException("illegal index");
            }
            return this.table[index];
        }

        public int read() throws IOException {
            if (this.bufferPos == this.limit) {
                this.limit = this.reader.read(this.buffer);
                this.bufferPos = 0;
            }
            if (this.limit == -1) {
                this.last_char = -1;
            } else {
                this.last_char = this.buffer[this.bufferPos++];
                ++this.pos;
            }
            return this.last_char;
        }

        public int readSkippingWS() throws IOException {
            do {
                this.last_char = this.read();
            } while (Character.isWhitespace(this.last_char));
            return this.last_char;
        }

        public int skipWS() throws IOException {
            while (Character.isWhitespace(this.last_char)) {
                this.last_char = this.read();
            }
            return this.last_char;
        }

        public int readOct() throws IOException {
            int val = Character.digit(this.last_char, 8);
            if ((val += Character.digit(this.read(), 8)) < 0) {
                throw new FactParseError("octal must have 3 octdigits.", this.getPosition());
            }
            if ((val += Character.digit(this.read(), 8)) < 0) {
                throw new FactParseError("octal must have 3 octdigits", this.getPosition());
            }
            return val;
        }

        public int getLastChar() {
            return this.last_char;
        }

        public int getPosition() {
            return this.pos;
        }
    }
}

