/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.IWriter;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedTypeException;
import org.eclipse.imp.pdb.facts.io.AbstractReader;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTextReader
extends AbstractReader {
    private static final char START_OF_LOC = '!';
    private static final char START_OF_MAP = '(';
    private static final char START_OF_TUPLE = '<';
    private static final char START_OF_SET = '{';
    private static final char START_OF_LIST = '[';
    private static final char END_OF_TUPLE = '>';
    private static final char COMMA_SEPARATOR = ',';
    private static final char END_OF_MAP = ')';
    private static final char DOUBLE_DOT = '.';
    private static final char END_OF_SET = '}';
    private static final char END_OF_LIST = ']';
    private TypeStore store;
    private NoWhiteSpaceInputStream stream;
    private IValueFactory factory;
    private TypeFactory types;
    private int current;

    @Override
    public IValue read(IValueFactory factory, TypeStore store, Type type, InputStream stream) throws FactTypeUseException, IOException {
        this.store = store;
        this.stream = new NoWhiteSpaceInputStream(stream);
        this.factory = factory;
        this.types = TypeFactory.getInstance();
        this.current = stream.read();
        return this.readValue(type);
    }

    private IValue readValue(Type expected) throws IOException {
        IValue result = null;
        if (Character.isDigit(this.current)) {
            result = this.readNumber(expected);
        } else if (Character.isJavaIdentifierStart(this.current) || this.current == 92) {
            result = this.readNode(expected);
        } else {
            switch (this.current) {
                case 91: {
                    result = this.readList(expected);
                    break;
                }
                case 123: {
                    result = this.readSet(expected);
                    break;
                }
                case 60: {
                    result = this.readTuple(expected);
                    break;
                }
                case 40: {
                    result = this.readMap(expected);
                    break;
                }
                case 33: {
                    result = this.readLocation(expected);
                    break;
                }
                default: {
                    this.unexpected();
                }
            }
        }
        if (!result.getType().isSubtypeOf(expected)) {
            throw new UnexpectedTypeException(expected, result.getType());
        }
        if (this.current == 91) {
            if (result.getType().isSubtypeOf(this.types.nodeType())) {
                result = this.readAnnos(expected, (INode)result);
            } else {
                this.unexpected(93);
            }
        }
        return result;
    }

    private IValue readLocation(Type expected) throws IOException {
        return null;
    }

    private IValue readMap(Type expected) throws IOException {
        Type keyType = expected.isMapType() ? expected.getKeyType() : this.types.valueType();
        Type valueType = expected.isMapType() ? expected.getValueType() : this.types.valueType();
        IMapWriter w = this.factory.mapWriter(keyType, valueType);
        this.current = this.stream.read();
        while (this.current != 41) {
            IValue key = this.readValue(keyType);
            this.checkAndRead(':');
            IValue value = this.readValue(valueType);
            w.put(key, value);
            if (this.current != 44 || this.current == 41) break;
            this.current = this.stream.read();
        }
        if (this.current != 41) {
            this.unexpected(41);
        }
        return w.done();
    }

    private IValue readTuple(Type expected) throws IOException {
        ArrayList<IValue> arr = new ArrayList<IValue>();
        this.readFixed(expected, '>', arr);
        IValue[] result = new IValue[arr.size()];
        return this.factory.tuple(arr.toArray(result));
    }

    private IValue readSet(Type expected) throws FactTypeUseException, IOException {
        Type elemType = expected.isSetType() ? expected.getElementType() : this.types.valueType();
        return this.readContainer(expected, this.factory.setWriter(elemType), '}');
    }

    private IValue readList(Type expected) throws FactTypeUseException, IOException {
        Type elemType = expected.isListType() ? expected.getElementType() : this.types.valueType();
        return this.readContainer(expected, this.factory.listWriter(elemType), ']');
    }

    private IValue readNumber(Type expected) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (Character.isDigit(this.current) || this.current == 46) {
            builder.append((char)this.current);
            this.current = this.stream.read();
        }
        String val = builder.toString();
        try {
            return this.factory.integer(val);
        }
        catch (NumberFormatException e) {
            try {
                return this.factory.real(val);
            }
            catch (NumberFormatException e2) {
                this.unexpected(this.current);
                return null;
            }
        }
    }

    private IValue readNode(Type expected) throws IOException {
        String id = this.readIdentifier();
        if (id.equals("true")) {
            return this.factory.bool(true);
        }
        if (id.equals("false")) {
            return this.factory.bool(false);
        }
        if (this.current == 40) {
            ArrayList<IValue> arr = new ArrayList<IValue>();
            this.readFixed(expected, ')', arr);
            IValue[] result = new IValue[arr.size()];
            result = arr.toArray(result);
            if (expected.isConstructorType()) {
                return expected.make(this.factory, result);
            }
            if (expected.isAbstractDataType()) {
                Type[] children = new Type[arr.size()];
                for (int i = 0; i < arr.size(); ++i) {
                    children[i] = arr.get(i).getType();
                }
                Type args = this.types.tupleType(children);
                Type cons = this.store.lookupConstructor(expected, id, args);
                if (cons != null) {
                    return cons.make(this.factory, result);
                }
            }
            return this.factory.node(id, result);
        }
        Type args = this.types.tupleType(new Type[0]);
        Type cons = this.store.lookupConstructor(expected, id, args);
        if (cons != null) {
            return cons.make(this.factory);
        }
        return this.factory.node(id);
    }

    private String readIdentifier() throws IOException {
        boolean escaped;
        StringBuilder builder = new StringBuilder();
        boolean bl = escaped = this.current == 92;
        if (escaped) {
            this.current = this.stream.read();
        }
        while (Character.isJavaIdentifierStart(this.current) || Character.isJavaIdentifierPart(this.current) || escaped && this.current == 45) {
            builder.append((char)this.current);
            this.current = this.stream.read();
        }
        return builder.toString();
    }

    private IValue readAnnos(Type expected, INode result) throws IOException {
        this.current = this.stream.read();
        while (this.current != 93) {
            this.checkAndRead('@');
            String key = this.readIdentifier();
            this.checkAndRead('=');
            Type annoType = this.getAnnoType(expected, key);
            IValue value = this.readValue(annoType);
            result = result.setAnnotation(key, value);
            this.current = this.stream.read();
            if (this.current != 44) break;
            this.current = this.stream.read();
        }
        return result;
    }

    private Type getAnnoType(Type expected, String key) {
        Type annoType = expected.isAbstractDataType() || expected.isConstructorType() ? (expected.declaresAnnotation(this.store, key) ? this.store.getAnnotationType(expected, key) : this.types.valueType()) : this.types.valueType();
        return annoType;
    }

    private void readFixed(Type expected, char end, List<IValue> arr) throws IOException {
        this.current = this.stream.read();
        int i = 0;
        while (this.current != end) {
            Type exp = expected.isTupleType() || expected.isConstructorType() ? expected.getFieldType(i) : this.types.valueType();
            arr.add(this.readValue(exp));
            if (this.current != 44 || this.current == end) break;
            this.current = this.stream.read();
            ++i;
        }
        this.checkAndRead(end);
    }

    private IValue readContainer(Type elemType, IWriter w, char end) throws FactTypeUseException, IOException {
        this.current = this.stream.read();
        int i = 0;
        while (this.current != end) {
            w.insert(this.readValue(elemType));
            if (this.current != 44 || this.current == end) break;
            this.current = this.stream.read();
            ++i;
        }
        this.checkAndRead(end);
        return w.done();
    }

    private void checkAndRead(char c) throws IOException {
        if (this.current != c) {
            this.unexpected(c);
        }
        this.current = this.stream.read();
    }

    private void unexpected(int c) {
        throw new FactParseError("Expected " + (char)c + " but got " + (char)this.current, this.stream.getOffset());
    }

    private void unexpected() {
        throw new FactParseError("Unexpected " + (char)this.current, this.stream.getOffset());
    }

    private class NoWhiteSpaceInputStream
    extends InputStream {
        private InputStream wrapped;
        int offset;
        int line;
        int column;

        public NoWhiteSpaceInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        public int read() throws IOException {
            int r = this.wrapped.read();
            ++this.offset;
            ++this.column;
            while (Character.isWhitespace(r)) {
                ++this.offset;
                if (r == 10) {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                r = this.wrapped.read();
            }
            return r;
        }

        int getOffset() {
            return this.offset;
        }
    }
}

