/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalConstructorApplicationException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredAnnotationException;
import org.eclipse.imp.pdb.facts.type.AbstractDataType;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.TupleType;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstructorType
extends Type {
    private final TupleType fChildrenTypes;
    private final AbstractDataType fADT;
    private final String fName;

    ConstructorType(String name, TupleType childrenTypes, AbstractDataType adt) {
        this.fName = name;
        this.fChildrenTypes = childrenTypes;
        this.fADT = adt;
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other == this || other == this.fADT) {
            return true;
        }
        return this.fADT.isSubtypeOf(other);
    }

    @Override
    public Type lub(Type other) {
        if (other.isConstructorType()) {
            return this.fADT.lub(other.getAbstractDataType());
        }
        if (other.isAbstractDataType()) {
            return this.getAbstractDataType().lub(other);
        }
        if (other.isNodeType()) {
            return other;
        }
        return super.lub(other);
    }

    @Override
    public Type carrier() {
        return this.fChildrenTypes.carrier();
    }

    public int hashCode() {
        return 21 + 44927 * (this.fName != null ? this.fName.hashCode() : 1) + 181 * this.fChildrenTypes.hashCode() + 354767453 * this.fADT.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ConstructorType) {
            return (this.fName == null ? ((ConstructorType)o).fName == null : this.fName.equals(((ConstructorType)o).fName)) && this.fChildrenTypes == ((ConstructorType)o).fChildrenTypes && this.fADT == ((ConstructorType)o).fADT;
        }
        return false;
    }

    @Override
    public boolean isConstructorType() {
        return true;
    }

    @Override
    public boolean isNodeType() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fADT);
        builder.append("::=");
        builder.append(this.fName);
        builder.append("(");
        Iterator<Type> iter = this.fChildrenTypes.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int getArity() {
        return this.fChildrenTypes.getArity();
    }

    @Override
    public int getFieldIndex(String fieldName) throws FactTypeUseException {
        return this.fChildrenTypes.getFieldIndex(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fChildrenTypes.hasField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName, TypeStore store) {
        return this.hasField(fieldName);
    }

    @Override
    public TupleType getFieldTypes() {
        return this.fChildrenTypes;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Type getAbstractDataType() {
        return this.fADT;
    }

    @Override
    public Type getFieldType(int i) {
        return this.fChildrenTypes.getFieldType(i);
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitConstructor(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return f.constructor(this);
    }

    @Override
    public IValue make(IValueFactory f, int arg) {
        TypeFactory tf = TypeFactory.getInstance();
        if (this.getArity() == 1 && this.getFieldType(0).isSubtypeOf(tf.integerType())) {
            return this.make(f, f.integer(arg));
        }
        throw new IllegalConstructorApplicationException(this, tf.tupleType(tf.integerType()));
    }

    @Override
    public IValue make(IValueFactory f, double arg) {
        TypeFactory tf = TypeFactory.getInstance();
        if (this.getArity() == 1 && this.getFieldType(0).isSubtypeOf(tf.realType())) {
            return this.make(f, f.real(arg));
        }
        throw new IllegalConstructorApplicationException(this, tf.tupleType(tf.realType()));
    }

    @Override
    public IValue make(IValueFactory f, String arg) {
        TypeFactory tf = TypeFactory.getInstance();
        if (this.getArity() == 1 && this.getFieldType(0).isSubtypeOf(tf.stringType())) {
            return this.make(f, f.string(arg));
        }
        throw new IllegalConstructorApplicationException(this, tf.tupleType(tf.stringType()));
    }

    @Override
    public IValue make(IValueFactory vf, IValue ... args) {
        return vf.constructor(this, args);
    }

    @Override
    public IValue make(IValueFactory vf, TypeStore ts, IValue ... args) {
        return this.make(vf, args);
    }

    @Override
    public IValue make(IValueFactory f, String name, IValue ... children) {
        if (!name.equals(this.fName)) {
            throw new UnsupportedOperationException(name + " does not match constructor name " + this.getName());
        }
        Type childrenTypes = TypeFactory.getInstance().tupleType(children);
        if (!childrenTypes.isSubtypeOf(this.fChildrenTypes)) {
            throw new IllegalConstructorApplicationException(this, childrenTypes);
        }
        return this.make(f, children);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, String name, IValue ... children) {
        return this.make(f, name, children);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        this.fADT.match(matched.getAbstractDataType(), bindings);
        this.getFieldTypes().match(matched.getFieldTypes(), bindings);
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        Type adt = this.fADT.instantiate(store, bindings);
        Type fields = this.getFieldTypes().instantiate(store, bindings);
        return TypeFactory.getInstance().constructorFromTuple(store, adt, this.getName(), fields);
    }

    @Override
    public boolean declaresAnnotation(TypeStore store, String label) {
        return store.getAnnotationType(this, label) != null;
    }

    @Override
    public Type getAnnotationType(TypeStore store, String label) throws FactTypeUseException {
        Type type = store.getAnnotationType(this, label);
        if (type == null) {
            throw new UndeclaredAnnotationException(this.getAbstractDataType(), label);
        }
        return type;
    }

    @Override
    public boolean isParameterized() {
        return this.fADT.isParameterized();
    }
}

