/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapType
extends Type {
    private final Type fKeyType;
    private final Type fValueType;

    MapType(Type keyType, Type valueType) {
        this.fKeyType = keyType;
        this.fValueType = valueType;
    }

    @Override
    public Type getKeyType() {
        return this.fKeyType;
    }

    @Override
    public Type getValueType() {
        return this.fValueType;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isSubtypeOf(Type o) {
        if (o.isMapType()) {
            return this.fKeyType.isSubtypeOf(o.getKeyType()) && this.fValueType.isSubtypeOf(o.getValueType());
        }
        return super.isSubtypeOf(o);
    }

    @Override
    public Type lub(Type o) {
        if (o.isMapType()) {
            return TypeFactory.getInstance().mapType(this.fKeyType.lub(o.getKeyType()), this.fValueType.lub(o.getValueType()));
        }
        return super.lub(o);
    }

    @Override
    public Type carrier() {
        TypeFactory tf = TypeFactory.getInstance();
        return tf.setType(this.fKeyType.lub(this.fValueType));
    }

    public int hashCode() {
        return 56509 + 3511 * this.fKeyType.hashCode() + 1171 * this.fValueType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MapType)) {
            return false;
        }
        MapType other = (MapType)obj;
        return this.fKeyType == other.fKeyType && this.fValueType == other.fValueType;
    }

    public String toString() {
        return "map[" + this.fKeyType + "," + this.fValueType + "]";
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitMap(this);
    }

    @Override
    public IMap make(IValueFactory f) {
        return f.map(this.fKeyType, this.fValueType);
    }

    public IMapWriter writer(IValueFactory f) {
        return f.mapWriter(this.fKeyType, this.fValueType);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        this.getKeyType().match(matched.getKeyType(), bindings);
        this.getValueType().match(matched.getValueType(), bindings);
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        return TypeFactory.getInstance().mapType(this.getKeyType().instantiate(store, bindings), this.getValueType().instantiate(store, bindings));
    }
}

