/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.contentProposer;

import java.util.ArrayList;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.imp.editor.SourceProposal;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.prefspecs.parser.Ast.IfieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.IfieldSpecs;
import org.eclipse.imp.prefspecs.parser.Ast.ItopLevelItem;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.customSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirListFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fieldSpecs;
import org.eclipse.imp.prefspecs.parser.Ast.fieldsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optionalSpecs;
import org.eclipse.imp.prefspecs.parser.Ast.pageBody;
import org.eclipse.imp.prefspecs.parser.Ast.pageSpec;
import org.eclipse.imp.prefspecs.parser.Ast.prefSpecs;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.tabsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.topLevelItemList;
import org.eclipse.imp.prefspecs.parser.PrefspecsParseController;
import org.eclipse.imp.services.IContentProposer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefspecsContentProposer
implements IContentProposer {
    private ArrayList<String> tabNames = null;
    private ArrayList<String> attributeKeywords = null;
    private ArrayList<String> fieldTypeNames = null;
    private int startTabs = 0;
    private int endTabs = 0;
    private int startFields = 0;
    private int endFields = 0;
    private int startCustom = 0;
    private int endCustom = 0;
    private int startConditionals = 0;
    private int endConditionals = 0;

    private IToken getToken(IParseController controller, int offset) {
        IPrsStream stream = ((SimpleLPGParseController)controller).getParser().getIPrsStream();
        PrefspecsParseController psPC = (PrefspecsParseController)controller;
        int index = stream.getTokenIndexAtCharacter(offset);
        int token_index = index < 0 ? -(index - 1) : index;
        int previous_index = stream.getPrevious(token_index);
        return stream.getIToken((stream.getKind(previous_index) == 15 || psPC.isKeyword(stream.getKind(previous_index))) && offset == stream.getEndOffset(previous_index) + 1 ? previous_index : token_index);
    }

    private String getPrefix(IToken token, int offset) {
        if (offset >= token.getStartOffset() && offset <= token.getEndOffset() + 1) {
            return token.toString().substring(0, offset - token.getStartOffset());
        }
        return "";
    }

    public ICompletionProposal[] getContentProposals(IParseController controller, int offset, ITextViewer viewer) {
        ArrayList<SourceProposal> result = new ArrayList<SourceProposal>();
        ArrayList<String> fieldIDs = this.getFieldIdentifiers(controller, offset);
        IToken token = this.getToken(controller, offset);
        int kind = -1;
        if (token != null) {
            kind = token.getKind();
        }
        if (token == null || !this.kindCanBeCompleted(controller, kind)) {
            result.add(new SourceProposal("No completion exists for that prefix", "", offset));
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        this.setSectionLimits(controller, offset);
        String prefix = this.getPrefix(token, offset);
        int tokenPosition = token.getStartOffset();
        if (this.startCustom > 0 && tokenPosition > this.startCustom && tokenPosition < this.endCustom) {
            switch (kind) {
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    if ("default".startsWith(prefix)) {
                        result.add(new SourceProposal("default", prefix, offset));
                        break;
                    }
                    if ("configuration".startsWith(prefix)) {
                        result.add(new SourceProposal("configuration", prefix, offset));
                        break;
                    }
                    if ("instance".startsWith(prefix)) {
                        result.add(new SourceProposal("instance", prefix, offset));
                        break;
                    }
                    if (!"project".startsWith(prefix)) break;
                    result.add(new SourceProposal("project", prefix, offset));
                }
            }
        }
        if (tokenPosition > this.startFields && tokenPosition < this.endFields) {
            ArrayList<String> ftn = this.getFieldTypeNames();
            for (String candidate : ftn) {
                if (!candidate.startsWith(prefix)) continue;
                result.add(new SourceProposal(candidate, prefix, offset));
            }
        }
        if (this.startCustom > 0 && tokenPosition > this.startCustom && tokenPosition < this.endCustom || this.startConditionals > 0 && tokenPosition > this.startConditionals && tokenPosition < this.endConditionals || this.startFields > 0 && tokenPosition > this.startFields && tokenPosition < this.endFields) {
            for (String candidate : fieldIDs) {
                if (!candidate.startsWith(prefix)) continue;
                result.add(new SourceProposal(candidate, prefix, offset));
            }
        }
        if (tokenPosition > this.startTabs && tokenPosition < this.endTabs || tokenPosition > this.startFields && tokenPosition < this.endFields || this.startCustom > 0 && tokenPosition > this.startCustom && tokenPosition < this.endCustom) {
            ArrayList<String> kw = this.getAttributeKeywords();
            for (String candidate : kw) {
                if (!candidate.startsWith(prefix)) continue;
                result.add(new SourceProposal(candidate, prefix, offset));
            }
        }
        if (!(tokenPosition > this.startTabs && tokenPosition < this.endTabs || tokenPosition > this.startFields && tokenPosition < this.endFields || this.startCustom > 0 && tokenPosition > this.startCustom && tokenPosition < this.endCustom || this.startConditionals > 0 && tokenPosition > this.startConditionals && tokenPosition < this.endConditionals)) {
            result.add(new SourceProposal("No completions available at this position", "", offset));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    public ArrayList<String> getFieldIdentifiers(IParseController controller, int offset) {
        ArrayList<String> result = new ArrayList<String>();
        prefSpecs prefSpecs2 = (prefSpecs)controller.getCurrentAst();
        if (prefSpecs2 == null) {
            return result;
        }
        pageSpec ps = this.getPageAtOffset(prefSpecs2, offset);
        IfieldSpecs specs = null;
        pageBody pb = ps.getpageBody();
        if (pb == null) {
            return result;
        }
        specs = pb.getfieldsSpec().getfieldSpecs();
        do {
            IfieldSpec fs;
            if (specs instanceof fieldSpecs) {
                fs = ((fieldSpecs)specs).getfieldSpec();
                specs = ((fieldSpecs)specs).getfieldSpecs();
            } else {
                fs = (IfieldSpec)specs;
                specs = null;
            }
            if (fs instanceof booleanFieldSpec) {
                result.add(((booleanFieldSpec)fs).getidentifier().toString());
                continue;
            }
            if (fs instanceof comboFieldSpec) {
                result.add(((comboFieldSpec)fs).getidentifier().toString());
                continue;
            }
            if (fs instanceof dirListFieldSpec) {
                result.add(((dirListFieldSpec)fs).getidentifier().toString());
                continue;
            }
            if (fs instanceof fileFieldSpec) {
                result.add(((fileFieldSpec)fs).getidentifier().toString());
                continue;
            }
            if (fs instanceof intFieldSpec) {
                result.add(((intFieldSpec)fs).getidentifier().toString());
                continue;
            }
            if (!(fs instanceof radioFieldSpec)) continue;
            result.add(((radioFieldSpec)fs).getidentifier().toString());
        } while (specs != null);
        return result;
    }

    private pageSpec getPageAtOffset(prefSpecs prefSpecs2, int offset) {
        topLevelItemList itemList = prefSpecs2.gettopLevelItems();
        for (int i = 0; i < itemList.size(); ++i) {
            pageSpec page;
            ItopLevelItem item = itemList.gettopLevelItemAt(i);
            if (!(item instanceof pageSpec) || (page = (pageSpec)item).getLeftIToken().getStartOffset() > offset || page.getRightIToken().getEndOffset() < offset) continue;
            return page;
        }
        return null;
    }

    public ArrayList<String> getTabNames() {
        if (this.tabNames == null) {
            this.tabNames = new ArrayList();
            this.tabNames.add("default");
            this.tabNames.add("configuration");
            this.tabNames.add("instance");
            this.tabNames.add("project");
        }
        return this.tabNames;
    }

    public ArrayList<String> getAttributeKeywords() {
        if (this.attributeKeywords == null) {
            this.attributeKeywords = new ArrayList();
            this.attributeKeywords.add("defvalue");
            this.attributeKeywords.add("emptyallowed");
            this.attributeKeywords.add("hasspecial");
            this.attributeKeywords.add("iseditable");
            this.attributeKeywords.add("isremovable");
            this.attributeKeywords.add("range");
        }
        return this.attributeKeywords;
    }

    public ArrayList<String> getFieldTypeNames() {
        if (this.fieldTypeNames == null) {
            this.fieldTypeNames = new ArrayList();
            this.fieldTypeNames.add("boolean");
            this.fieldTypeNames.add("combo");
            this.fieldTypeNames.add("dirlist");
            this.fieldTypeNames.add("file");
            this.fieldTypeNames.add("int");
            this.fieldTypeNames.add("radio");
            this.fieldTypeNames.add("string");
        }
        return this.fieldTypeNames;
    }

    public boolean kindCanBeCompleted(IParseController controller, int kind) {
        switch (kind) {
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        PrefspecsParseController psPC = (PrefspecsParseController)controller;
        return psPC.isKeyword(kind);
    }

    private void setSectionLimits(IParseController controller, int offset) {
        prefSpecs prefSpecs2 = (prefSpecs)controller.getCurrentAst();
        if (prefSpecs2 == null) {
            return;
        }
        pageSpec ps = this.getPageAtOffset(prefSpecs2, offset);
        pageBody pb = ps.getpageBody();
        optionalSpecs optSpecs = pb.getoptionalSpecs();
        tabsSpec ts = pb.gettabsSpec();
        this.startTabs = ts != null ? ts.getLeftIToken().getStartOffset() : 0;
        this.endTabs = ts != null ? ts.getRightIToken().getEndOffset() : 0;
        fieldsSpec fs = pb.getfieldsSpec();
        this.startFields = fs.getLeftIToken().getStartOffset();
        this.endFields = fs.getRightIToken().getEndOffset();
        customSpec cso = optSpecs.getcustomSpecOption();
        this.startCustom = cso != null ? cso.getLeftIToken().getStartOffset() : 0;
        this.endCustom = cso != null ? cso.getRightIToken().getEndOffset() : 0;
        conditionalsSpec condsSpec = optSpecs.getconditionalsSpecOption();
        this.startConditionals = condsSpec != null ? condsSpec.getLeftIToken().getStartOffset() : 0;
        this.endConditionals = condsSpec != null ? condsSpec.getRightIToken().getEndOffset() : 0;
    }
}

