/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import org.eclipse.imp.prefspecs.pageinfo.PreferencesTabInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualBooleanFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConcreteFieldInfo {
    protected VirtualFieldInfo vFieldInfo = null;
    protected PreferencesTabInfo parentTab = null;
    protected String name = null;
    protected boolean isEditable = true;
    protected boolean isRemovable = false;
    protected String optLabel = null;
    protected boolean hasSpecialValue = false;
    protected boolean isConditional = false;
    protected boolean conditionalWith = true;
    protected VirtualBooleanFieldInfo conditionField = null;

    public ConcreteFieldInfo(VirtualFieldInfo vFieldInfo, PreferencesTabInfo parentTab) {
        if (vFieldInfo == null) {
            throw new IllegalArgumentException("ConcreteFieldInfo(..\t):  virtual field is null; not allowed");
        }
        if (parentTab == null) {
            throw new IllegalArgumentException("ConcreteFieldInfo(..):  parent tab is null; not allowed");
        }
        this.parentTab = parentTab;
        this.vFieldInfo = vFieldInfo;
        this.name = vFieldInfo.getName();
        this.isEditable = vFieldInfo.getIsEditable();
        this.isRemovable = vFieldInfo.getIsRemovable();
        this.optLabel = vFieldInfo.getLabel();
        this.hasSpecialValue = vFieldInfo.getHasSpecialValue();
        parentTab.add(this);
        vFieldInfo.addConcreteFieldInfo(this);
    }

    public PreferencesTabInfo getParentTab() {
        return this.parentTab;
    }

    public String getName() {
        return this.name;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean getIsRemovable() {
        if (this.getName().equals("default")) {
            return false;
        }
        return this.isRemovable;
    }

    public void setIsRemovable(boolean isRemovable) {
        if (this.getName().equals("default") && isRemovable) {
            throw new IllegalArgumentException("ConcreteFieldInfo.setIsRemovable(..):  cannot set isRemovable ");
        }
        this.isRemovable = isRemovable;
    }

    public String getLabel() {
        return this.optLabel;
    }

    public void setLabel(String newLabel) {
        this.optLabel = newLabel;
    }

    public boolean getHasSpecialValue() {
        return this.hasSpecialValue;
    }

    public void setHasSpecialValue(boolean hasSpecialValue) {
        this.hasSpecialValue = hasSpecialValue;
    }

    public String getToolTip() {
        return this.vFieldInfo.getToolTipText();
    }

    public boolean getIsConditional() {
        return this.isConditional;
    }

    public void setIsConditional(boolean b) {
        this.isConditional = b;
    }

    public boolean getConditionalWith() {
        return this.conditionalWith;
    }

    public void setConditionalWith(boolean b) {
        this.conditionalWith = b;
    }

    public VirtualBooleanFieldInfo getConditionField() {
        return this.conditionField;
    }

    public void setConditionField(VirtualBooleanFieldInfo vbf) {
        this.conditionField = vbf;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        String indent = prefix + "  ";
        out.println(prefix + "Field '" + this.getName() + "'");
        out.println(indent + "parent page = " + this.getParentTab().getName());
        out.println(indent + "isEditable  = " + this.isEditable);
        out.println(indent + "isRemovable = " + this.isRemovable);
        out.println(indent + "hasSpecial = " + this.hasSpecialValue);
        if (this.isConditional) {
            out.println(indent + "isConditional " + (this.conditionalWith ? "with" : "against") + " " + (this.conditionField != null ? this.conditionField.getName() : "<unknown>"));
        } else {
            out.println(indent + "isConditional  = false");
        }
    }
}

