/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

public class VirtualDoubleFieldInfo
extends VirtualFieldInfo {
    protected double defaultValue = 0.0;
    protected boolean hasRangeSpec = false;
    protected double rangeHigh = Double.MAX_VALUE;
    protected double rangeLow = Double.MIN_VALUE;

    public VirtualDoubleFieldInfo(PreferencesPageInfo parentPage, String name) {
        super(parentPage, name);
    }

    public VirtualDoubleFieldInfo(PreferencesPageInfo parentPage, String name, double defValue) {
        this(parentPage, name);
        this.defaultValue = defValue;
    }

    public void setDefaultValue(double d) {
        if (d < this.getRangeLow() || d > this.getRangeHigh()) {
            throw new IllegalArgumentException("VirtualDoubleFieldInfo.setDefaultValue(double):  attempt to set default value = " + d + " outside of range = " + this.getRangeLow() + ".." + this.getRangeHigh());
        }
        this.defaultValue = d;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasRangeSpec() {
        return this.hasRangeSpec;
    }

    public void setRange(double low, double high) {
        if (high < low) {
            throw new IllegalArgumentException("VirtualDoubleFieldInfo.setRange(double,double):  given high value = " + high + " is less than low value " + low);
        }
        this.hasRangeSpec = true;
        this.rangeLow = low;
        this.rangeHigh = high;
    }

    public double getRangeHigh() {
        return this.rangeHigh;
    }

    public double getRangeLow() {
        return this.rangeLow;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        out.println(indent + "defaultVallue    = " + this.getDefaultValue());
    }
}

