/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.io.IValueReader;
import org.eclipse.imp.pdb.facts.io.binary.BinaryReader;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;

public class PBFReader
implements IValueReader {
    public IValue read(IValueFactory valueFactory, InputStream inputStream) throws IOException {
        return this.doRead(valueFactory, new TypeStore(new TypeStore[0]), inputStream);
    }

    public IValue read(IValueFactory valueFactory, Type type, InputStream inputStream) throws IOException {
        return this.doRead(valueFactory, new TypeStore(new TypeStore[0]), inputStream);
    }

    public IValue read(IValueFactory valueFactory, TypeStore typeStore, Type type, InputStream inputStream) throws IOException {
        return this.doRead(valueFactory, typeStore, inputStream);
    }

    private IValue doRead(IValueFactory valueFactory, TypeStore typeStore, InputStream inputStream) throws IOException {
        BinaryReader binaryReader = new BinaryReader(valueFactory, typeStore, inputStream);
        return binaryReader.deserialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IValue readValueFromFile(IValueFactory valueFactory, TypeStore typeStore, File file) throws IOException {
        IValue result;
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
            BinaryReader binaryReader = new BinaryReader(valueFactory, typeStore, fis);
            result = binaryReader.deserialize();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return result;
    }
}

