/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class EditorInputUtils {
    public static IPath getPath(IEditorInput editorInput) {
        IPath path = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            path = fileEditorInput.getFile().getProjectRelativePath();
        } else if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathInput = (IPathEditorInput)editorInput;
            path = pathInput.getPath();
        } else if (editorInput instanceof IStorageEditorInput) {
            IStorageEditorInput storageEditorInput = (IStorageEditorInput)editorInput;
            try {
                path = storageEditorInput.getStorage().getFullPath();
            }
            catch (CoreException e) {}
        } else if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (wsRoot.getProject((path = new Path(uriEditorInput.getURI().getPath())).segment(0)).exists()) {
                path = path.removeFirstSegments(1);
            }
        }
        return path;
    }

    public static IFile getFile(IEditorInput editorInput) {
        IFile file = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            file = fileEditorInput.getFile();
        } else if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathInput = (IPathEditorInput)editorInput;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (wsRoot.getLocation().isPrefixOf(pathInput.getPath())) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(pathInput.getPath());
            }
        } else if (editorInput instanceof IStorageEditorInput) {
            file = null;
        } else if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            URI uri = uriEditorInput.getURI();
            String path = uri.getPath();
            if (uri.getScheme().equals("file") && (uri.getHost() == null || uri.getHost().equals("localhost")) && !path.startsWith(wsRoot.getLocation().toOSString())) {
                file = wsRoot.getFile((IPath)new Path(path));
            }
        }
        return file;
    }

    public static String getNameExtension(IEditorInput editorInput) {
        return EditorInputUtils.getPath(editorInput).getFileExtension();
    }
}

