/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.ui.graph;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class MyDirectedGraphLayout
extends DirectedGraphLayoutAlgorithm {
    public MyDirectedGraphLayout(int styles) {
        super(styles);
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        HashMap<InternalNode, Node> mapping = new HashMap<InternalNode, Node>(entitiesToLayout.length);
        DirectedGraph graph = new DirectedGraph();
        for (InternalNode internalNode : entitiesToLayout) {
            Node node = new Node((Object)internalNode);
            node.setSize(new Dimension(10, 10));
            mapping.put(internalNode, node);
            this.addNode(graph, node);
        }
        for (InternalNode internalNode : relationshipsToConsider) {
            Node source = (Node)mapping.get(internalNode.getSource());
            Node dest = (Node)mapping.get(internalNode.getDestination());
            Edge edge = new Edge((Object)internalNode, source, dest);
            this.addEdge(graph, edge);
        }
        DirectedGraphLayout directedGraphLayout = new DirectedGraphLayout();
        directedGraphLayout.visit(graph);
        for (Object o : graph.nodes) {
            Node node = (Node)o;
            InternalNode internalNode = (InternalNode)node.data;
            if ((this.layout_styles & 0x100) == 256) {
                internalNode.setInternalLocation((double)node.y, (double)node.x);
                continue;
            }
            internalNode.setInternalLocation((double)node.x, (double)node.y);
        }
        this.updateLayoutLocations(entitiesToLayout);
    }

    private boolean addEdge(DirectedGraph graph, Edge edge) {
        return graph.edges.add((Object)edge);
    }

    private boolean addNode(DirectedGraph graph, Node node) {
        return graph.nodes.add((Object)node);
    }
}

