/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.parser;

import java.io.IOException;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexParser;
import lpg.runtime.LpgLexStream;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import org.eclipse.imp.lpg.parser.JavaKWLexer;
import org.eclipse.imp.lpg.parser.JavaLexerprs;
import org.eclipse.imp.lpg.parser.JavaParsersym;

public class JavaLexer
implements RuleAction {
    private JavaLexerLpgLexStream lexStream;
    private static ParseTable prs = new JavaLexerprs();
    private LexParser lexParser = new LexParser();
    JavaKWLexer kwLexer;
    boolean printTokens;
    private static final int ECLIPSE_TAB_VALUE = 4;

    public ParseTable getParseTable() {
        return prs;
    }

    public LexParser getParser() {
        return this.lexParser;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getToken(1);
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public void resetKeywordLexer() {
        if (this.kwLexer == null) {
            this.kwLexer = new JavaKWLexer(this.lexStream.getInputChars(), 2);
        } else {
            this.kwLexer.setInputChars(this.lexStream.getInputChars());
        }
    }

    public void reset(String filename, int tab) throws IOException {
        this.lexStream = new JavaLexerLpgLexStream(filename, tab);
        this.lexParser.reset((ILexStream)this.lexStream, prs, (RuleAction)this);
        this.resetKeywordLexer();
    }

    public void reset(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    public void reset(char[] input_chars, String filename, int tab) {
        this.lexStream = new JavaLexerLpgLexStream(input_chars, filename, tab);
        this.lexParser.reset((ILexStream)this.lexStream, prs, (RuleAction)this);
        this.resetKeywordLexer();
    }

    public JavaLexer(String filename, int tab) throws IOException {
        this.reset(filename, tab);
    }

    public JavaLexer(char[] input_chars, String filename, int tab) {
        this.reset(input_chars, filename, tab);
    }

    public JavaLexer(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    public JavaLexer() {
    }

    public ILexStream getILexStream() {
        return this.lexStream;
    }

    public ILexStream getLexStream() {
        return this.lexStream;
    }

    private void initializeLexer(IPrsStream prsStream, int start_offset, int end_offset) {
        if (this.lexStream.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.lexStream.setPrsStream(prsStream);
        prsStream.makeToken(start_offset, end_offset, 0);
    }

    private void addEOF(IPrsStream prsStream, int end_offset) {
        prsStream.makeToken(end_offset, end_offset, 85);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public void lexer(IPrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, IPrsStream prsStream) {
        this.initializeLexer(prsStream, 0, -1);
        this.lexParser.parseCharacters(monitor);
        this.addEOF(prsStream, this.lexStream.getStreamIndex());
    }

    public void lexer(IPrsStream prsStream, int start_offset, int end_offset) {
        this.lexer(null, prsStream, start_offset, end_offset);
    }

    public void lexer(Monitor monitor, IPrsStream prsStream, int start_offset, int end_offset) {
        if (start_offset <= 1) {
            this.initializeLexer(prsStream, 0, -1);
        } else {
            this.initializeLexer(prsStream, start_offset - 1, start_offset - 1);
        }
        this.lexParser.parseCharacters(monitor, start_offset, end_offset);
        this.addEOF(prsStream, end_offset >= this.lexStream.getStreamIndex() ? this.lexStream.getStreamIndex() : end_offset + 1);
    }

    public void reportLexicalError(int startLoc, int endLoc) {
        IPrsStream prs_stream = this.lexStream.getPrsStream();
        if (prs_stream == null) {
            this.lexStream.reportLexicalError(startLoc, endLoc);
        } else {
            for (int i = prs_stream.getSize() - 1; i > 0 && prs_stream.getStartOffset(i) >= startLoc; --i) {
                prs_stream.removeLastToken();
            }
            prs_stream.makeToken(startLoc, endLoc, 0);
        }
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public JavaLexer(String filename) throws IOException {
        this(filename, 4);
        this.kwLexer = new JavaKWLexer(this.lexStream.getInputChars(), 2);
    }

    public void initialize(char[] content, String filename) {
        this.reset(content, filename);
    }

    final void makeToken(int left_token, int right_token, int kind) {
        this.lexStream.makeToken(left_token, right_token, kind);
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.makeToken(startOffset, endOffset, kind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.getIPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
        if (this.printTokens) {
            this.printValue(this.getLeftSpan(), this.getRightSpan());
        }
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void checkForKeyWord(int defaultKind) {
        int endOffset;
        int startOffset = this.getLeftSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset = this.getRightSpan());
        if (kwKind == 2) {
            kwKind = defaultKind;
        }
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void printValue(int startOffset, int endOffset) {
        String s = new String(this.lexStream.getInputChars(), startOffset, endOffset - startOffset + 1);
        System.out.print(s);
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(37);
                break;
            }
            case 3: {
                this.makeToken(36);
                break;
            }
            case 4: {
                this.makeToken(32);
                break;
            }
            case 5: {
                this.makeToken(34);
                break;
            }
            case 6: {
                this.makeToken(35);
                break;
            }
            case 7: {
                this.skipToken();
                break;
            }
            case 8: {
                this.skipToken();
                break;
            }
            case 9: {
                this.skipToken();
                break;
            }
            case 10: {
                this.makeToken(47);
                break;
            }
            case 11: {
                this.makeToken(46);
                break;
            }
            case 12: {
                this.makeToken(69);
                break;
            }
            case 13: {
                this.makeToken(90);
                break;
            }
            case 14: {
                this.makeToken(3);
                break;
            }
            case 15: {
                this.makeToken(20);
                break;
            }
            case 16: {
                this.makeToken(51);
                break;
            }
            case 17: {
                this.makeToken(43);
                break;
            }
            case 18: {
                this.makeToken(50);
                break;
            }
            case 19: {
                this.makeToken(4);
                break;
            }
            case 20: {
                this.makeToken(92);
                break;
            }
            case 21: {
                this.makeToken(88);
                break;
            }
            case 22: {
                this.makeToken(49);
                break;
            }
            case 23: {
                this.makeToken(86);
                break;
            }
            case 24: {
                this.makeToken(68);
                break;
            }
            case 25: {
                this.makeToken(24);
                break;
            }
            case 26: {
                this.makeToken(44);
                break;
            }
            case 27: {
                this.makeToken(42);
                break;
            }
            case 28: {
                this.makeToken(48);
                break;
            }
            case 29: {
                this.makeToken(23);
                break;
            }
            case 30: {
                this.makeToken(53);
                break;
            }
            case 31: {
                this.makeToken(27);
                break;
            }
            case 32: {
                this.makeToken(45);
                break;
            }
            case 33: {
                this.makeToken(91);
                break;
            }
            case 34: {
                this.makeToken(1);
                break;
            }
            case 35: {
                this.makeToken(28);
                break;
            }
            case 36: {
                this.makeToken(26);
                break;
            }
            case 37: {
                this.makeToken(93);
                break;
            }
            case 38: {
                this.makeToken(81);
                break;
            }
            case 39: {
                this.makeToken(87);
                break;
            }
            case 40: {
                this.makeToken(70);
                break;
            }
            case 41: {
                this.makeToken(79);
                break;
            }
            case 42: {
                this.makeToken(72);
                break;
            }
            case 43: {
                this.makeToken(75);
                break;
            }
            case 44: {
                this.makeToken(76);
                break;
            }
            case 45: {
                this.makeToken(74);
                break;
            }
            case 46: {
                this.makeToken(78);
                break;
            }
            case 47: {
                this.makeToken(77);
                break;
            }
            case 48: {
                this.makeToken(73);
                break;
            }
            case 49: {
                this.makeToken(80);
                break;
            }
            case 50: {
                this.makeToken(95);
                break;
            }
            case 51: {
                this.makeToken(89);
                break;
            }
            case 52: {
                this.makeToken(96);
                break;
            }
        }
    }

    static class JavaLexerLpgLexStream
    extends LpgLexStream {
        public static final int[] tokenKind = new int[]{102, 102, 102, 102, 102, 102, 102, 102, 102, 37, 100, 102, 38, 101, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 73, 82, 34, 98, 75, 81, 76, 24, 95, 96, 80, 35, 93, 36, 31, 79, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 86, 87, 78, 18, 94, 92, 83, 21, 22, 23, 13, 17, 14, 54, 55, 56, 57, 58, 30, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 33, 70, 71, 90, 77, 91, 85, 53, 97, 19, 15, 20, 12, 16, 11, 39, 40, 41, 42, 43, 25, 44, 26, 45, 46, 47, 27, 48, 28, 29, 49, 50, 32, 51, 52, 88, 74, 89, 84, 72, 99};

        public final int getKind(int i) {
            int c;
            int n = c = i >= this.getStreamLength() ? 65535 : (int)this.getCharValue(i);
            return c < 128 ? tokenKind[c] : (c == 65535 ? 99 : 72);
        }

        public String[] orderedExportedSymbols() {
            return JavaParsersym.orderedTerminalSymbols;
        }

        public JavaLexerLpgLexStream(String filename, int tab) throws IOException {
            super(filename, tab);
        }

        public JavaLexerLpgLexStream(char[] input_chars, String filename, int tab) {
            super(input_chars, filename, tab);
        }

        public JavaLexerLpgLexStream(char[] input_chars, String filename) {
            super(input_chars, filename, 1);
        }
    }
}

