/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IMessageHandler;
import lpg.runtime.Monitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.JavaActionBlockAutomaticVisitor;
import org.eclipse.imp.lpg.parser.JavaActionBlockUserDefinedVisitor;
import org.eclipse.imp.lpg.parser.JavaActionBlockVisitor;
import org.eclipse.imp.lpg.parser.LPGLexer;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.lpg.parser.LPGSyntaxProperties;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.LPGSourcePositionLocator;
import org.eclipse.imp.parser.MessageHandlerAdapter;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.services.ILanguageSyntaxProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseController
extends SimpleLPGParseController
implements IParseController {
    private JavaActionBlockVisitor actionVisitor;

    public ParseController() {
        super(LPGRuntimePlugin.getInstance().getLanguageID());
        this.fLexer = new LPGLexer();
        this.fParser = new LPGParser();
    }

    public ISourcePositionLocator getSourcePositionLocator() {
        return new LPGSourcePositionLocator((IParseController)this);
    }

    public ILanguageSyntaxProperties getSyntaxProperties() {
        return new LPGSyntaxProperties();
    }

    public List<LPGParser.option> getOptions(LPGParser.LPG root) {
        ArrayList<LPGParser.option> result = new ArrayList<LPGParser.option>();
        String template_file = null;
        LPGParser.option_specList optSeg = root.getoptions_segment();
        for (int i = 0; i < optSeg.size(); ++i) {
            LPGParser.option_spec optSpec = optSeg.getoption_specAt(i);
            LPGParser.optionList optList = optSpec.getoption_list();
            for (int o = 0; o < optList.size(); ++o) {
                LPGParser.Ioption_value optValue;
                LPGParser.option opt = optList.getoptionAt(o);
                result.add(opt);
                LPGParser.ASTNodeToken sym = opt.getSYMBOL();
                String optName = ((Object)sym).toString();
                if (!optName.equals("template") || !((optValue = opt.getoption_value()) instanceof LPGParser.option_value__EQUAL_SYMBOL)) continue;
                template_file = ((LPGParser.option_value__EQUAL_SYMBOL)optValue).getSYMBOL().toString();
            }
        }
        if (template_file != null) {
            PreferencesService prefSvc = new PreferencesService(this.fProject.getRawProject(), LPGRuntimePlugin.getInstance().getLanguageID());
            String include_str = prefSvc.getBooleanPreference("UseDefaultIncludePath") ? prefSvc.getStringPreference("default", "IncludePathToUse") : prefSvc.getStringPreference("IncludePathToUse");
            int i = -1;
            do {
                int offset;
                String filename;
                File f;
                if (!(f = new File(filename = include_str.substring(offset = i + 1, (i = include_str.indexOf(59, offset)) == -1 ? include_str.length() : i) + template_file)).exists()) continue;
                try {
                    LPGLexer lex = new LPGLexer(filename);
                    LPGParser prs = new LPGParser(lex.getILexStream());
                    lex.lexer(prs.getIPrsStream());
                    LPGParser.LPG template_root = (LPGParser.LPG)prs.parser();
                    if (template_root == null) continue;
                    result.addAll(this.getOptions(template_root));
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                }
            } while (i != -1);
        }
        return result;
    }

    public Object parse(String contents, IProgressMonitor monitor) {
        SimpleLPGParseController.PMMonitor my_monitor = new SimpleLPGParseController.PMMonitor((SimpleLPGParseController)this, monitor);
        char[] contentsArray = contents.toCharArray();
        this.fLexer.reset(contentsArray, this.fFilePath.toOSString());
        this.fParser.reset(this.fLexer.getILexStream());
        this.fParser.getIPrsStream().setMessageHandler((IMessageHandler)new MessageHandlerAdapter(this.handler));
        this.cacheKeywordsOnce();
        this.fLexer.lexer((Monitor)my_monitor, this.fParser.getIPrsStream());
        if (my_monitor.isCancelled()) {
            return this.fCurrentAst;
        }
        this.fCurrentAst = (LPGParser.ASTNode)this.fParser.parser((Monitor)my_monitor, 0);
        if (this.fCurrentAst == null) {
            this.fParser.getIPrsStream().dumpTokens();
        } else {
            boolean is_java = false;
            boolean automatic_ast = false;
            for (LPGParser.option opt : this.getOptions((LPGParser.LPG)this.fCurrentAst)) {
                LPGParser.ASTNodeToken sym = opt.getSYMBOL();
                String optName = ((Object)sym).toString();
                if (optName.equalsIgnoreCase("programming-language") || optName.equalsIgnoreCase("programming_language") || optName.equalsIgnoreCase("programminglanguage") || optName.equalsIgnoreCase("table")) {
                    LPGParser.Ioption_value optValue = opt.getoption_value();
                    if (!(optValue instanceof LPGParser.option_value__EQUAL_SYMBOL)) continue;
                    is_java = ((LPGParser.option_value__EQUAL_SYMBOL)optValue).getSYMBOL().toString().equalsIgnoreCase("java");
                    continue;
                }
                if (optName.equalsIgnoreCase("automatic-ast") || optName.equalsIgnoreCase("automatic_ast") || optName.equalsIgnoreCase("automaticast")) {
                    automatic_ast = true;
                    continue;
                }
                if (!optName.equalsIgnoreCase("noautomatic-ast") && !optName.equalsIgnoreCase("noautomatic_ast") && !optName.equalsIgnoreCase("noautomaticast")) continue;
                automatic_ast = false;
            }
            if (is_java) {
                this.actionVisitor = automatic_ast ? new JavaActionBlockAutomaticVisitor() : new JavaActionBlockUserDefinedVisitor();
                this.actionVisitor.reset(this.fParser);
                ((LPGParser.ASTNode)this.fCurrentAst).accept(this.actionVisitor);
            }
        }
        return this.fCurrentAst;
    }
}

