/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class PopInstruction
extends Instruction {
    private final byte size;

    protected PopInstruction(byte size) {
        super((short)-1);
        this.size = size;
    }

    public static PopInstruction make(int size) {
        if (size < 0 || size > 2) {
            throw new IllegalArgumentException("Invalid pop size: " + size);
        }
        return new PopInstruction((byte)size);
    }

    public boolean equals(Object o) {
        if (o instanceof PopInstruction) {
            PopInstruction i = (PopInstruction)o;
            return i.size == this.size;
        }
        return false;
    }

    public int hashCode() {
        return this.size + 8431890;
    }

    public int getPoppedCount() {
        return this.size;
    }

    public void visit(IInstruction.Visitor v) throws IllegalArgumentException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        v.visitPop(this);
    }

    public String toString() {
        return "Pop(" + this.size + ")";
    }

    public boolean isPEI() {
        return false;
    }
}

