/*******************************************************************************
* Copyright (c) 2007 IBM Corporation.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*    Robert Fuhrer (rfuhrer@watson.ibm.com) - initial API and implementation

*******************************************************************************/

/**
 * 
 */
package org.eclipse.imp.wizards;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.utils.ExtensionPointUtils;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
	
/**
 * An ExtensionPointWizard that also generates source code from one or more template files.
 * @author rfuhrer@watson.ibm.com
 */
public abstract class CodeServiceWizard extends ExtensionPointWizard {

	
//    /**
//     * Collects basic information from wizard-page fields and computes
//     * additional common values for use by wizards in generating code.
//     * 	
//     * Can be extended by subclasses for specific wizards in order to
//     * gather wizard-specific values.
//     */
//    protected void collectCodeParms() {
//    	fProject = pages[0].getProjectOfRecord();
//    	fProjectName = pages[0].fProjectText.getText();
//        fLanguageName= pages[0].fLanguageText.getText();
//        
//        if (pages[0].fTemplateText != null)
//        	fTemplateName = pages[0].fTemplateText.getText();
//        
//        fClassNamePrefix= Character.toUpperCase(fLanguageName.charAt(0)) + fLanguageName.substring(1);
//        
//		String qualifiedClassName= pages[0].getField("class").fValue;
//		fFullClassName = qualifiedClassName.substring(qualifiedClassName.lastIndexOf('.') + 1);
//		fPackageName= qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf('.'));
//		fPackageFolder= fPackageName.replace('.', File.separatorChar);
//
//		fParserPackage = discoverParserPackage(fProject);
//    }

//    
//    /**
//     * Overrides method in ExtensionPointWizard.
//     *
//     * Provides a basic implementation that returns the name of the
//     * one class that will definitely be generated by a specific wizard.	
//     * 
//     * Subclasses should override if the wizard will generate more than
//     * one implementation class.
//     * 
//     * @return	An array of names of existing files that would be clobbered by
//     * 			the new files to be generated
//     */
//    protected String[] getFilesThatCouldBeClobbered() {
//    	
//    	// In case there's not any implementation class ...
//    	if (fFullClassName == null) {
//    		return new String[0];
//    	}
//    	
//    	// In the usual case that there is ...
//    	
//    	String prefix = fProject.getLocation().toString() + '/' + getProjectSourceLocation(fProject);
//    	// getProjectSourceLocation should return a "/"-terminated string
//    	String prefixTail = (fPackageName == null ? "/" : fPackageName.replace('.', '/') + "/");
//    	prefix = prefix + prefixTail; 
//    	
//    	return new String[] {prefix + fFullClassName + ".java" };
//    }	


    
//    public Map<String,String> getStandardSubstitutions(IProject project) {
//    	Map<String, String> result = getStandardSubstitutions();
//    	result.remove("$PLUGIN_PACKAGE$");
//        result.put("$PLUGIN_PACKAGE$", getPluginPackageName(project, null));
//    	result.remove("$PLUGIN_CLASS$");
//        result.put("$PLUGIN_CLASS$", getPluginClassName(project, null));
//        result.remove("$PLUGIN_ID$");
//        result.put("$PLUGIN_ID$", getPluginID(project, null));
//        return result;
//    }
//    
//    
//    
//    public Map<String, String> getStandardSubstitutions() {
//        Map<String,String> result = new HashMap();
//        
//        // SMS 17 May 2006
//        // Need to get a name for the AST package and AST node type for use in
//        // the NewFoldingUpdater wizard
//        // Note:  The method used assumes that these are the default values
//        // (if that assumption is wrong, then the generated folding service won't
//        // compile, but if we don't provide any values then it won't compile in
//        // any case--specifically because substitutions for these parameters will
//        // not have been made)
//        result = ExtensionPointUtils.getASTInformation((IPluginModel)pages[0].getPluginModel(), fProject);
//        
//        // continuing with original:
//        result.put("$LANG_NAME$", fLanguageName);
//        result.put("$CLASS_NAME_PREFIX$", fClassNamePrefix);
//        result.put("$PACKAGE_NAME$", fPackageName);
//        // SMS 22 Mar 2007
//        result.put("$PROJECT_NAME$", fProjectName);
//        // SMS 23 Mar 2007
//        // Not the greatest solution, but if we don't have the
//        // project then we may as well assume that $PLUGIN_PACKAGE$
//        // has a default value
//        result.put("$PLUGIN_PACKAGE$", getPluginPackageName(null, null));
//        // SMS 27 Mar 2007:  ditto
//        result.put("$PLUGIN_CLASS$", getPluginClassName(null, null));
//        result.put("$PLUGIN_ID$", getPluginID(null, null));
//
//        return result;
//    }
    
}
