/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class BinaryOpInstruction
extends Instruction {
    private static final BinaryOpInstruction[] arithmeticOps = BinaryOpInstruction.preallocateArithmeticOps();
    private static final BinaryOpInstruction[] logicalOps = BinaryOpInstruction.preallocateLogicalOps();

    protected BinaryOpInstruction(short opcode) {
        super(opcode);
    }

    private static BinaryOpInstruction[] preallocateArithmeticOps() {
        BinaryOpInstruction[] r = new BinaryOpInstruction[20];
        for (short i = 96; i <= 115; i = (short)(i + 1)) {
            r[i - 96] = new BinaryOpInstruction(i);
        }
        return r;
    }

    private static BinaryOpInstruction[] preallocateLogicalOps() {
        BinaryOpInstruction[] r = new BinaryOpInstruction[6];
        for (short i = 126; i <= 131; i = (short)(i + 1)) {
            r[i - 126] = new BinaryOpInstruction(i);
        }
        return r;
    }

    public static BinaryOpInstruction make(String type, Operator operator) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        int t = Util.getTypeIndex(type);
        if (t < 0) {
            throw new IllegalArgumentException("Invalid type for BinaryOp: " + type);
        }
        if (operator.compareTo(Operator.REM) <= 0) {
            if (t > 3) {
                throw new IllegalArgumentException("Invalid type for BinaryOp: " + type);
            }
            return arithmeticOps[(operator.ordinal() - Operator.ADD.ordinal()) * 4 + t];
        }
        if (t > 1) {
            throw new IllegalArgumentException("Cannot use logical binaryOps on floating point type: " + type);
        }
        return logicalOps[(operator.ordinal() - Operator.AND.ordinal()) * 2 + t];
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryOpInstruction) {
            BinaryOpInstruction i = (BinaryOpInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public Operator getOperator() {
        if (this.opcode < 126) {
            return Operator.values()[(this.opcode - 96) / 4];
        }
        return Operator.values()[(this.opcode - 126) / 2];
    }

    public int hashCode() {
        return this.opcode + 13901901;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] types) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        int t = this.opcode < 126 ? this.opcode - 96 & 3 : this.opcode - 126 & 1;
        return indexedTypes[t];
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitBinaryOp(this);
    }

    public String toString() {
        return "BinaryOp(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return this.opcode == 108;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator implements IOperator
    {
        ADD,
        SUB,
        MUL,
        DIV,
        REM,
        AND,
        OR,
        XOR;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static interface IOperator {
    }
}

