/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields.details;

import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.BooleanFieldEditor;
import org.eclipse.imp.preferences.fields.PreferenceDialogConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DetailsDialogForBooleanFields
extends TrayDialog {
    Shell parent = null;
    BooleanFieldEditor field = null;
    Composite fieldHolder = null;
    IPreferencesService preferencesService = null;
    private PreferencesUtilities prefUtils = null;
    private static final int REMOVE_ID = 1025;
    private static final int SPECIAL_ID = 1027;
    protected Composite workArea = null;
    protected Composite dialogAreaParent = null;

    public DetailsDialogForBooleanFields(Shell parent, BooleanFieldEditor field, Composite fieldHolder, IPreferencesService preferencesService) {
        super(parent);
        this.parent = parent;
        this.field = field;
        this.fieldHolder = fieldHolder;
        this.preferencesService = preferencesService;
        this.prefUtils = new PreferencesUtilities(this.preferencesService);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                if (this.field.getPreferencesLevel().equals(this.field.getLevelFromWhichLoaded())) {
                    this.preferencesService.clearPreferenceAtLevel(this.field.getPreferencesLevel(), this.field.getPreferenceName());
                }
                this.prefUtils.setField(this.field, this.fieldHolder);
                break;
            }
            case 1027: {
                this.prefUtils.setField(this.field, this.fieldHolder, (Boolean)this.field.getSpecialValue());
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
        this.close();
    }

    public boolean close() {
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)("Details for ''" + this.field.getLabelText() + "''"), null));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        Button specialButton = this.createButton(parent, 1027, "Set Special", false);
        specialButton.setEnabled(this.field.getChangeControl().isEnabled() && this.field.hasSpecialValue() && this.field.getPreferencesLevel() != null);
        Button removeButton = this.createButton(parent, 1025, "Remove", false);
        removeButton.setEnabled(this.field.getChangeControl().isEnabled() && this.field.getPreferencesLevel() != null && this.field.getPreferencesLevel().equals(this.field.getLevelFromWhichLoaded()) && this.field.isRemovable());
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogAreaParent = parent;
        Composite workArea = new Composite(parent, 0);
        workArea = this.fillInWorkArea(workArea);
        return workArea;
    }

    private Composite fillInWorkArea(Composite workArea) {
        if (workArea.isDisposed()) {
            System.err.println("fillInWorkArea:  workArea is disposed!");
        }
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)this.parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)this.parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        topContainer.setLayoutData((Object)data);
        String levelString = null;
        if (this.field.getPreferencesLevel() == null) {
            levelString = "Details as currently applicable";
            levelString = this.preferencesService.getProject() != null ? levelString + " (including project preferences):  " : levelString + " (not including any project preferences):  ";
        } else {
            levelString = this.field.getPreferencesLevel().equals("instance") ? "Details in effect at preferences level 'workspace instance' " : (this.field.getPreferencesLevel().equals("configuration") ? "Details in effect at preferences level 'workspace configuration' " : (this.field.getPreferencesLevel().equals("default") ? "Details in effect at preferences level 'default' " : (this.field.getPreferencesLevel().equals("project") ? "Details in effect at preferences level 'project' " : "Details in effect at preferences level " + this.field.getPreferencesLevel())));
        }
        Label label = null;
        label = new Label(topContainer, 16384);
        label.setText(levelString);
        label.setBackground(PreferencesUtilities.colorWhite);
        label = new Label(topContainer, 16384);
        label.setText("\tCurrent value:  '" + this.field.getChangeControl().getSelection() + "'");
        label.setBackground(PreferencesUtilities.colorWhite);
        label = new Label(topContainer, 16384);
        String level = PreferenceDialogConstants.getLevelName(this.field.getLevelFromWhichLoaded());
        label.setText("\tLevel at which set:  " + level);
        label.setBackground(PreferencesUtilities.colorWhite);
        label = new Label(topContainer, 16384);
        if (this.field.hasSpecialValue()) {
            label.setText("\tHas special value:  " + this.field.getSpecialValue());
        } else {
            label.setText("\tHas no special value");
        }
        label.setBackground(PreferencesUtilities.colorWhite);
        if (this.field.getPreferencesLevel() != null && this.field.getPreferencesLevel().equals(this.field.getLevelFromWhichLoaded())) {
            label = new Label(topContainer, 16384);
            if (this.field.isRemovable()) {
                label.setText("\tPreference is removable");
            } else {
                label.setText("\tPreference is not removable");
            }
        }
        label.setBackground(PreferencesUtilities.colorWhite);
        label = new Label(top, 16384);
        label.setText("~~~");
        label.setVisible(false);
        this.workArea = workArea;
        return workArea;
    }
}

