/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.search;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.xform.search.ASTSearchQuery;
import org.eclipse.imp.xform.search.ASTSearchScope;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ASTSearchPage
extends DialogPage
implements ISearchPage {
    private ISearchPageContainer fContainer;
    private Text fPattern;
    private Combo fLangCombo;

    public ASTSearchPage() {
        this("AST Search");
    }

    public ASTSearchPage(String title) {
        this(title, null);
    }

    public ASTSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean performAction() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("JikesPGTest");
        boolean isWorkspaceScope = this.fContainer.getSelectedScope() == 0;
        ASTSearchScope scope = isWorkspaceScope ? ASTSearchScope.createWorkspaceScope() : ASTSearchScope.createProjectScope(project);
        ASTSearchQuery query = new ASTSearchQuery(this.fPattern.getText(), this.fLangCombo.getText(), scope);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Label langLabel = new Label(result, 16384);
        langLabel.setText("Language:");
        langLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.fLangCombo = new Combo(result, 12);
        Collection langs = LanguageRegistry.getLanguages();
        for (Language lang : langs) {
            this.fLangCombo.add(lang.getName());
        }
        this.fLangCombo.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.fLangCombo.select(0);
        Label patLabel = new Label(result, 16384);
        patLabel.setText("AST pattern:");
        patLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.fPattern = new Text(result, 18432);
        this.fPattern.setText("");
        this.setControl((Control)result);
    }
}

