/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.search;

import java.io.InputStream;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.utils.StreamUtils;
import org.eclipse.imp.xform.pattern.matching.IASTMatcher;
import org.eclipse.imp.xform.pattern.matching.MatchResult;
import org.eclipse.imp.xform.pattern.matching.Matcher;
import org.eclipse.imp.xform.pattern.parser.ASTPatternLexer;
import org.eclipse.imp.xform.pattern.parser.ASTPatternParser;
import org.eclipse.imp.xform.pattern.parser.Ast.Pattern;
import org.eclipse.imp.xform.search.ASTSearchResult;
import org.eclipse.imp.xform.search.ASTSearchScope;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class ASTSearchQuery
implements ISearchQuery {
    private String fASTPatternString;
    private String fLanguageName;
    private Language fLanguage;
    private Pattern fASTPattern;
    private IASTMatcher fASTAdapter;
    private ASTSearchScope fScope;
    private ASTSearchResult fResult;

    public ASTSearchQuery(String astPattern, String languageName, ASTSearchScope scope) {
        this.fASTPatternString = astPattern;
        this.fLanguageName = languageName;
        this.fLanguage = LanguageRegistry.findLanguage((String)this.fLanguageName);
        this.fScope = scope;
        this.fResult = new ASTSearchResult(this);
        this.fASTAdapter = (IASTMatcher)ServiceFactory.getInstance().getASTAdapter(this.fLanguage);
        ASTPatternParser.setASTAdapter(this.fASTAdapter);
        ASTPatternLexer lexer = new ASTPatternLexer(this.fASTPatternString.toCharArray(), "__PATTERN__");
        ASTPatternParser parser = new ASTPatternParser(lexer.getILexStream());
        lexer.lexer(parser.getIPrsStream());
        this.fASTPattern = (Pattern)parser.parser();
    }

    public IStatus run(final IProgressMonitor monitor) throws OperationCanceledException {
        final SystemOutMessageHandler msgHandler = new SystemOutMessageHandler();
        for (final IProject p : this.fScope.getProjects()) {
            try {
                p.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile) {
                            IFile file = (IFile)resource;
                            String exten = file.getFileExtension();
                            if (resource.isDerived()) {
                                System.out.println("Skipping derived resource " + resource.getFullPath());
                            }
                            if (exten != null && ASTSearchQuery.this.fLanguage.hasExtension(exten)) {
                                ISourceProject srcProject;
                                monitor.subTask("Searching " + file.getFullPath());
                                String contents = StreamUtils.readStreamContents((InputStream)file.getContents(), (String)ResourcesPlugin.getEncoding());
                                IParseController parseController = ServiceFactory.getInstance().getParseController(ASTSearchQuery.this.fLanguage);
                                try {
                                    srcProject = ModelFactory.open((IProject)p);
                                }
                                catch (ModelFactory.ModelException e) {
                                    ErrorHandler.reportError((String)e.getMessage());
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.imp.xform", 0, e.getMessage(), (Throwable)e));
                                }
                                if (parseController == null) {
                                    return false;
                                }
                                parseController.initialize(resource.getProjectRelativePath(), srcProject, msgHandler);
                                Object astRoot = parseController.parse(contents, monitor);
                                if (astRoot == null) {
                                    return false;
                                }
                                Matcher m = new Matcher(ASTSearchQuery.this.fASTPattern);
                                Set matches = ASTSearchQuery.this.fASTAdapter.findAllMatches(m, astRoot);
                                for (MatchResult match : matches) {
                                    Object matchNode = match.getMatchNode();
                                    Match textMatch = new Match((Object)file, ASTSearchQuery.this.fASTAdapter.getOffset(matchNode), ASTSearchQuery.this.fASTAdapter.getLength(matchNode));
                                    ASTSearchQuery.this.fResult.addMatch(textMatch);
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return new Status(0, "org.eclipse.imp.xform", 0, "Search complete", null);
    }

    public String getLabel() {
        return "<AST " + this.fASTPatternString + ">";
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    class SystemOutMessageHandler
    implements IMessageHandler {
        SystemOutMessageHandler() {
        }

        public void clearMessages() {
        }

        public void endMessageGroup() {
        }

        public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
            System.out.println("[" + startOffset + ":" + (endOffset - startOffset + 1) + "] " + msg);
        }

        public void startMessageGroup(String groupName) {
        }
    }
}

