/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesTabInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesPageInfo {
    private String name = null;
    private List<PreferencesTabInfo> tabs = null;
    private List<VirtualFieldInfo> virtualFields = new ArrayList<VirtualFieldInfo>();
    private boolean noDetails = false;
    public static String INDENT = "";

    public PreferencesPageInfo(String name) {
        this.name = name;
        this.tabs = new ArrayList<PreferencesTabInfo>(4);
    }

    public void setPageName(String name) {
        this.name = name;
    }

    public String getPageName() {
        return this.name;
    }

    public boolean getNoDetails() {
        return this.noDetails;
    }

    public void setNoDetails(boolean noDetails) {
        this.noDetails = noDetails;
    }

    public void addTabInfo(PreferencesTabInfo tab) {
        if (tab == null || this.tabs.contains(tab)) {
            return;
        }
        this.tabs.add(tab);
    }

    public void removeTabInfo(PreferencesTabInfo tab) {
        if (tab == null) {
            return;
        }
        this.tabs.remove(tab);
    }

    public Iterator<PreferencesTabInfo> getTabInfos() {
        return this.tabs.iterator();
    }

    public PreferencesTabInfo getTabInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("PreferencePageInfo.getTab(String):  given string is null; not allowed");
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            String tabName;
            PreferencesTabInfo tab = this.tabs.get(i);
            if (tab == null || !name.equals(tabName = tab.getName())) continue;
            return tab;
        }
        return null;
    }

    public boolean hasTabInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("PreferencePageInfo.hasTab(String):  given string is null; not allowed");
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            String tabName;
            PreferencesTabInfo tab = this.tabs.get(i);
            if (tab == null || !name.equals(tabName = tab.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasTabInfo(PreferencesTabInfo tab) {
        if (tab == null) {
            throw new IllegalArgumentException("PreferencePageInfo.hasTab(PreferencesTabInfo):  given tab is null; not allowed");
        }
        return this.tabs.contains(tab);
    }

    public void addVirtualFieldInfo(VirtualFieldInfo vField) {
        if (vField == null || this.virtualFields.contains(vField)) {
            return;
        }
        this.virtualFields.add(vField);
    }

    public void removeVirtualFieldInfo(VirtualFieldInfo vField) {
        if (vField == null) {
            return;
        }
        this.virtualFields.remove(vField);
    }

    public Iterator<VirtualFieldInfo> getVirtualFieldInfos() {
        return this.virtualFields.iterator();
    }

    public boolean hasVirtualFieldInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("PreferencePageInfo.hasVirtualField(String):  given name is null; not allowed");
        }
        for (int i = 0; i < this.virtualFields.size(); ++i) {
            String fieldName;
            VirtualFieldInfo field = this.virtualFields.get(i);
            if (field == null || !name.equals(fieldName = field.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasVirtualFieldInfo(VirtualFieldInfo vField) {
        if (vField == null) {
            throw new IllegalArgumentException("PreferencePageInfo.hasVirtualField(VirtualFieldInfo):  given field is null; not allowed");
        }
        return this.virtualFields.contains(vField);
    }

    public void dump(MessageConsoleStream out) {
        String indent = "  ";
        out.println("\n\t%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("PreferencesPageInfo:  '" + this.getPageName() + "'");
        out.println("Virtual fields:");
        for (VirtualFieldInfo vField : this.virtualFields) {
            vField.dump(indent, out);
        }
        out.println("Tabs:");
        for (PreferencesTabInfo tab : this.tabs) {
            tab.dump(indent, out);
        }
        out.println("\t%%%%\t%%%%\t%%%%\n");
    }
}

