/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.AnnotatedNode;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Value
implements INode {
    protected static final Type NODE_TYPE = TypeFactory.getInstance().nodeType();
    protected final String name;
    protected final IValue[] children;

    protected Node(String name, IValue[] children) {
        this.name = name != null ? name.intern() : null;
        this.children = children;
    }

    @Override
    public Type getType() {
        return NODE_TYPE;
    }

    @Override
    public int arity() {
        return this.children.length;
    }

    @Override
    public IValue get(int i) {
        return this.children[i];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<IValue> iterator() {
        return new Iterator<IValue>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Node.this.children.length;
            }

            @Override
            public IValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("There are no more elements in this iteration.");
                }
                return Node.this.children[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal is not supported by this iterator.");
            }
        };
    }

    @Override
    public Iterable<IValue> getChildren() {
        return this;
    }

    @Override
    public INode set(int i, IValue arg) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = arg;
        return new Node(this.name, newChildren);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitNode(this);
    }

    @Override
    public boolean hasAnnotation(String label) {
        return false;
    }

    @Override
    public boolean hasAnnotations() {
        return false;
    }

    @Override
    public IValue getAnnotation(String label) {
        return null;
    }

    @Override
    public Map<String, IValue> getAnnotations() {
        return new ShareableHashMap<String, IValue>();
    }

    @Override
    public INode setAnnotation(String label, IValue value) {
        return new AnnotatedNode(this.name, this.children, this.getUpdatedAnnotations(label, value));
    }

    @Override
    public INode setAnnotations(Map<String, IValue> newAnnos) {
        return new AnnotatedNode(this.name, this.children, this.getSetAnnotations(newAnnos));
    }

    @Override
    public INode joinAnnotations(Map<String, IValue> newAnnos) {
        return new AnnotatedNode(this.name, this.children, this.getUpdatedAnnotations(newAnnos));
    }

    @Override
    public INode removeAnnotation(String label) {
        return new AnnotatedNode(this.name, this.children, this.getUpdatedAnnotations(label));
    }

    @Override
    public INode removeAnnotations() {
        return this;
    }

    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        newAnnotations.put(label, value);
        return newAnnotations;
    }

    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        newAnnotations.remove(label);
        return newAnnotations;
    }

    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    protected ShareableHashMap<String, IValue> getSetAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = this.children.length - 1; i >= 0; --i) {
            hash = (hash << 23) + (hash >> 5);
            hash ^= this.children[i].hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Node other = (Node)o;
            if (this.name != other.name) {
                return false;
            }
            IValue[] otherChildren = other.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                for (int i = nrOfChildren - 1; i >= 0; --i) {
                    if (((Object)otherChildren[i]).equals(this.children[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Node) {
            Node other = (Node)value;
            if (this.name != other.name) {
                return false;
            }
            IValue[] otherChildren = other.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                for (int i = nrOfChildren - 1; i >= 0; --i) {
                    if (otherChildren[i].isEqual(this.children[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

