/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.IWriter;
import org.eclipse.imp.pdb.facts.exceptions.FactMatchException;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Type
implements Iterable<Type>,
Comparable<Type> {
    public Type getElementType() {
        throw new IllegalOperationException("getElementType", this);
    }

    public Type getKeyType() {
        throw new IllegalOperationException("getKeyType", this);
    }

    public Type getValueType() {
        throw new IllegalOperationException("getValueType", this);
    }

    public String getName() {
        throw new IllegalOperationException("getName", this);
    }

    public Type getFieldType(int i) {
        throw new IllegalOperationException("getFieldType", this);
    }

    public Type getFieldType(String fieldName) throws FactTypeUseException {
        throw new IllegalOperationException("getFieldType", this);
    }

    public Type getFieldTypes() {
        throw new IllegalOperationException("getFieldTypes", this);
    }

    public String getFieldName(int i) {
        throw new IllegalOperationException("getFieldName", this);
    }

    public int getFieldIndex(String fieldName) {
        throw new IllegalOperationException("getFieldIndex", this);
    }

    public boolean hasField(String fieldName) {
        throw new IllegalOperationException("hasField", this);
    }

    public boolean hasField(String fieldName, TypeStore store) {
        return this.hasField(fieldName);
    }

    public int getArity() {
        throw new IllegalOperationException("getArity", this);
    }

    public Type compose(Type other) {
        throw new IllegalOperationException("compose", this, other);
    }

    public Type closure() {
        throw new IllegalOperationException("closure", this);
    }

    public Type carrier() {
        throw new IllegalOperationException("carrier", this);
    }

    @Override
    public Iterator<Type> iterator() {
        throw new IllegalOperationException("iterator", this);
    }

    public Type select(int ... fields) {
        throw new IllegalOperationException("select", this);
    }

    public Type select(String ... names) {
        throw new IllegalOperationException("select", this);
    }

    public Type getAbstractDataType() {
        throw new IllegalOperationException("getAbstractDataType", this);
    }

    public Type getAliased() {
        throw new IllegalOperationException("getAliased", this);
    }

    public Type getBound() {
        throw new IllegalOperationException("getBound", this);
    }

    public boolean hasFieldNames() {
        throw new IllegalOperationException("getFieldNames", this);
    }

    public boolean declaresAnnotation(TypeStore store, String label) {
        return false;
    }

    public Type getAnnotationType(TypeStore store, String label) throws FactTypeUseException {
        throw new IllegalOperationException("getAnnotationType", this);
    }

    public String getKeyLabel() {
        throw new IllegalOperationException("getKeyLabel", this);
    }

    public String getValueLabel() {
        throw new IllegalOperationException("getValueLabel", this);
    }

    public Type lub(Type other) {
        if (other == this) {
            return this;
        }
        if (other.isVoidType()) {
            return this;
        }
        if (other.isAliasType()) {
            return this.lub(other.getAliased());
        }
        return TypeFactory.getInstance().valueType();
    }

    public boolean isSubtypeOf(Type other) {
        if (other.isValueType() && !other.isVoidType()) {
            return true;
        }
        if (other == this) {
            return true;
        }
        if (other.isAliasType() && !other.isVoidType()) {
            return this.isSubtypeOf(other.getAliased());
        }
        if (other.isParameterType() && !other.isVoidType()) {
            return this.isSubtypeOf(other.getBound());
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean comparable(Type other) {
        return other == this || this.isSubtypeOf(other) || other.isSubtypeOf(this);
    }

    public boolean equivalent(Type other) {
        return other == this || this.isSubtypeOf(other) && other.isSubtypeOf(this);
    }

    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        return this;
    }

    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!matched.isSubtypeOf(this)) {
            throw new FactMatchException(this, matched);
        }
    }

    public abstract <T> T accept(ITypeVisitor<T> var1);

    public boolean isRelationType() {
        return false;
    }

    public boolean isSetType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isIntegerType() {
        return false;
    }

    public boolean isRealType() {
        return false;
    }

    public boolean isStringType() {
        return false;
    }

    public boolean isSourceLocationType() {
        return false;
    }

    public boolean isSourceRangeType() {
        return false;
    }

    public boolean isAliasType() {
        return false;
    }

    public boolean isValueType() {
        return false;
    }

    public boolean isVoidType() {
        return false;
    }

    public boolean isExternalType() {
        return false;
    }

    public boolean isNodeType() {
        return false;
    }

    public boolean isConstructorType() {
        return false;
    }

    public boolean isAbstractDataType() {
        return false;
    }

    public boolean isMapType() {
        return false;
    }

    public boolean isBoolType() {
        return false;
    }

    public boolean isParameterType() {
        return false;
    }

    public boolean isDateTimeType() {
        return false;
    }

    public IValue make(IValueFactory f, double arg) {
        throw new IllegalOperationException("make double", this);
    }

    public IValue make(IValueFactory f, float arg) {
        throw new IllegalOperationException("make double", this);
    }

    public IValue make(IValueFactory f, TypeStore store, float arg) {
        throw new IllegalOperationException("make real", this);
    }

    public IValue make(IValueFactory f, TypeStore store, double arg) {
        throw new IllegalOperationException("make real", this);
    }

    public IValue make(IValueFactory f, int arg) {
        throw new IllegalOperationException("make int", this);
    }

    public IValue make(IValueFactory f, TypeStore store, int arg) {
        throw new IllegalOperationException("make int", this);
    }

    public IValue make(IValueFactory f, String arg) {
        throw new IllegalOperationException("make string", this);
    }

    public IValue make(IValueFactory f, TypeStore store, String arg) {
        throw new IllegalOperationException("make string", this);
    }

    public IValue make(IValueFactory f) {
        throw new IllegalOperationException("make zero constructor", this);
    }

    public IValue make(IValueFactory f, IValue ... args) {
        throw new IllegalOperationException("apply to children", this);
    }

    public IValue make(IValueFactory f, TypeStore ts, IValue ... args) {
        throw new IllegalOperationException("apply to children", this);
    }

    public IValue make(IValueFactory f, URI uri, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        throw new IllegalOperationException("make source location", this);
    }

    public IValue make(IValueFactory f, URI uri) {
        throw new IllegalOperationException("make source location", this);
    }

    public IValue make(IValueFactory f, String path, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        throw new IllegalOperationException("make source location", this);
    }

    public IValue make(IValueFactory f, String name, IValue ... children) {
        throw new IllegalOperationException("make tree constructor", this);
    }

    public IValue make(IValueFactory f, TypeStore store, String name, IValue ... children) {
        throw new IllegalOperationException("make tree constructor", this);
    }

    public IValue make(IValueFactory f, boolean arg) {
        throw new IllegalOperationException("make boolean", this);
    }

    public IValue make(IValueFactory f, TypeStore store, boolean arg) {
        throw new IllegalOperationException("make boolean", this);
    }

    public IValue make(IValueFactory f, int year, int month, int day) {
        throw new IllegalOperationException("make datetime", this);
    }

    public IValue make(IValueFactory f, int hour, int minute, int second, int millisecond) {
        throw new IllegalOperationException("make datetime", this);
    }

    public IValue make(IValueFactory f, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        throw new IllegalOperationException("make datetime", this);
    }

    public IValue make(IValueFactory f, int year, int month, int day, int hour, int minute, int second, int millisecond) {
        throw new IllegalOperationException("make datetime", this);
    }

    public IValue make(IValueFactory f, int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        throw new IllegalOperationException("make datetime", this);
    }

    public IValue make(IValueFactory f, long instant) {
        throw new IllegalOperationException("make datetime", this);
    }

    public <T extends IWriter> T writer(IValueFactory f) {
        throw new IllegalOperationException("writer", this);
    }

    public Type getHiddenType() {
        throw new IllegalOperationException("getHiddenType", this);
    }

    public Type getTypeParameters() {
        throw new IllegalOperationException("getTypeParameters", this);
    }

    @Override
    public int compareTo(Type o) {
        if (this.isSubtypeOf(o)) {
            return -1;
        }
        if (o.isSubtypeOf(this)) {
            return 1;
        }
        return 0;
    }
}

