/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.builders;

import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.box.Activator;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.box.parser.BoxParseController;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.builder.BuilderUtils;
import org.eclipse.imp.builder.MarkerCreator;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.imp.utils.StreamUtils;

public class BoxBuilder
extends BuilderBase {
    public static final String BUILDER_ID = "org.eclipse.imp.box.builder";
    public static final String PROBLEM_MARKER_ID = "org.eclipse.imp.box.problem";
    public static final String LANGUAGE_NAME = "Box";
    public static final Language LANGUAGE = LanguageRegistry.findLanguage((String)"Box");

    protected PluginBase getPlugin() {
        return Activator.getInstance();
    }

    protected String getErrorMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getWarningMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getInfoMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected boolean isSourceFile(IFile file) {
        IPath path = file.getRawLocation();
        if (path == null) {
            return false;
        }
        String pathString = path.toString();
        if (pathString.indexOf("/bin/") != -1) {
            return false;
        }
        return LANGUAGE.hasExtension(path.getFileExtension());
    }

    protected boolean isNonRootSourceFile(IFile resource) {
        return false;
    }

    protected void collectDependencies(IFile file) {
    }

    protected boolean isOutputFolder(IResource resource) {
        return resource.getFullPath().lastSegment().equals("bin");
    }

    protected void compile(IFile file, IProgressMonitor monitor) {
        try {
            this.runParserForCompiler(file, monitor);
            this.doRefresh((IResource)file.getParent());
            String absPath = file.getLocation().toOSString();
            String box = BoxFactory.box2text(StreamUtils.readStreamContents((InputStream)file.getContents()));
            FileOutputStream out = new FileOutputStream(absPath + ".fmt");
            out.write(box.getBytes());
            out.close();
            this.doRefresh((IResource)file);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void runParserForCompiler(IFile file, IProgressMonitor monitor) {
        try {
            BoxParseController parseController = new BoxParseController();
            MarkerCreator markerCreator = new MarkerCreator(file, (IParseController)parseController, PROBLEM_MARKER_ID);
            parseController.getAnnotationTypeInfo().addProblemMarkerType(this.getErrorMarkerID());
            IProject project = file.getProject();
            ISourceProject sourceProject = null;
            try {
                sourceProject = ModelFactory.open((IProject)project);
            }
            catch (ModelFactory.ModelException me) {
                System.err.println("BoxParseController.runParserForComplier(..):  Model exception:\n" + me.getMessage() + "\nReturning without parsing");
                return;
            }
            parseController.initialize(file.getProjectRelativePath(), sourceProject, (IMessageHandler)markerCreator);
            String contents = BuilderUtils.getFileContents((IFile)file);
            parseController.parse(contents, monitor);
            this.doRefresh((IResource)file.getParent());
        }
        catch (Exception e) {
            this.getPlugin().writeErrorMsg(e.getMessage());
            e.printStackTrace();
        }
    }
}

