/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.browser;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectContextMenuAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    protected IProject fCurrentProject;
    private static SelectContextMenuAction fInstance;

    private SelectContextMenuAction() {
        this.setMenuCreator(this);
        this.setText("Context");
        this.setToolTipText("Select a context for the next analysis");
        this.getProjects();
    }

    public static SelectContextMenuAction getInstance() {
        if (fInstance == null) {
            fInstance = new SelectContextMenuAction();
        }
        return fInstance;
    }

    public Menu getMenu(Control parent) {
        IProject[] projects;
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        for (IProject project : projects = this.getProjects()) {
            final MenuItem menuItem = new MenuItem(this.fMenu, 16);
            menuItem.setText("Project: " + project.getName());
            menuItem.setData((Object)project);
            if (project.equals(this.fCurrentProject)) {
                menuItem.setSelection(true);
            } else {
                menuItem.setSelection(false);
            }
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectContextMenuAction.this.fCurrentProject = (IProject)e.widget.getData();
                    this.unselectOthers();
                    menuItem.setSelection(true);
                }

                private void unselectOthers() {
                    for (MenuItem item : SelectContextMenuAction.this.fMenu.getItems()) {
                        item.setSelection(false);
                    }
                }
            });
        }
        return this.fMenu;
    }

    private IProject[] getProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (this.fCurrentProject == null && projects.length > 0) {
            this.fCurrentProject = projects[0];
        }
        return projects;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public IProject getSelectedProject() {
        return this.fCurrentProject;
    }
}

