/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.util.Map;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Constructor;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedConstructor
extends Constructor
implements IShareable {
    protected SharedConstructor(Type constructorType, IValue[] children) {
        super(constructorType, children);
    }

    @Override
    public IConstructor set(int i, IValue newChild) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = newChild;
        return SharedValueFactory.getInstance().createConstructorUnsafe(this.constructorType, newChildren);
    }

    @Override
    public IConstructor set(String label, IValue newChild) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[this.constructorType.getFieldIndex((String)label)] = newChild;
        return SharedValueFactory.getInstance().createConstructorUnsafe(this.constructorType, newChildren);
    }

    @Override
    public IConstructor setAnnotation(String label, IValue value) {
        return SharedValueFactory.getInstance().createAnnotatedConstructorUnsafe(this.constructorType, this.children, this.getUpdatedAnnotations(label, value));
    }

    @Override
    public IConstructor setAnnotations(Map<String, IValue> newAnnos) {
        if (newAnnos.isEmpty()) {
            return this;
        }
        return SharedValueFactory.getInstance().createAnnotatedConstructorUnsafe(this.constructorType, this.children, this.getUpdatedAnnotations(newAnnos));
    }

    @Override
    public IConstructor joinAnnotations(Map<String, IValue> newAnnos) {
        return SharedValueFactory.getInstance().createAnnotatedConstructorUnsafe(this.constructorType, this.children, this.getUpdatedAnnotations(newAnnos));
    }

    @Override
    public IConstructor removeAnnotation(String label) {
        return SharedValueFactory.getInstance().createAnnotatedConstructorUnsafe(this.constructorType, this.children, this.getUpdatedAnnotations(label));
    }

    @Override
    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }
}

