/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.imp.pdb.facts.IValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShareableValuesHashSet
implements Set<IValue>,
Iterable<IValue> {
    private static final int INITIAL_LOG_SIZE = 4;
    private int modSize;
    private int hashMask;
    private Entry<IValue>[] data;
    private int threshold;
    private int load;
    private int currentHashCode;

    public ShareableValuesHashSet() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    public ShareableValuesHashSet(ShareableValuesHashSet shareableValuesHashSet) {
        this.modSize = shareableValuesHashSet.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = (Entry[])shareableValuesHashSet.data.clone();
        this.threshold = tableSize;
        this.load = shareableValuesHashSet.load;
        this.currentHashCode = shareableValuesHashSet.currentHashCode;
    }

    @Override
    public void clear() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    private void rehash() {
        ++this.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        this.threshold = tableSize;
        Entry<IValue>[] oldData = this.data;
        for (int i = oldData.length - 1; i >= 0; --i) {
            Entry<IValue> entry = oldData[i];
            if (entry == null) continue;
            Entry<IValue> lastUnchangedEntryChain = entry;
            int newLastUnchangedEntryChainIndex = entry.hash & this.hashMask;
            Entry e = entry.next;
            while (e != null) {
                int newIndex = e.hash & this.hashMask;
                if (newIndex != newLastUnchangedEntryChainIndex) {
                    lastUnchangedEntryChain = e;
                    newLastUnchangedEntryChainIndex = newIndex;
                }
                e = e.next;
            }
            newData[newLastUnchangedEntryChainIndex] = lastUnchangedEntryChain;
            while (entry != lastUnchangedEntryChain) {
                int hash = entry.hash;
                int position = hash & this.hashMask;
                newData[position] = new Entry(hash, entry.value, newData[position]);
                entry = entry.next;
            }
        }
        this.data = newData;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    @Override
    public boolean add(IValue value) {
        this.ensureCapacity();
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<IValue> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !((IValue)entry.value).isEqual(value)) continue;
                return false;
            } while ((entry = entry.next) != null);
        }
        this.data[position] = new Entry<IValue>(hash, value, currentStartEntry);
        ++this.load;
        this.currentHashCode ^= hash;
        return true;
    }

    @Override
    public boolean contains(Object object) {
        IValue value = (IValue)object;
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && value.isEqual((IValue)entry.value)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        IValue value = (IValue)object;
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<IValue> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !((IValue)entry.value).isEqual(value)) continue;
                Entry<IValue> e = this.data[position];
                this.data[position] = entry.next;
                while (e != entry) {
                    this.data[position] = new Entry<IValue>(e.hash, (IValue)e.value, this.data[position]);
                    e = e.next;
                }
                --this.load;
                this.currentHashCode ^= hash;
                return true;
            } while ((entry = entry.next) != null);
        }
        return false;
    }

    @Override
    public int size() {
        return this.load;
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    @Override
    public Iterator<IValue> iterator() {
        return new SetIterator(this);
    }

    @Override
    public boolean addAll(Collection<? extends IValue> collection) {
        boolean changed = false;
        Iterator<? extends IValue> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            changed |= this.add(collectionIterator.next());
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            if (this.contains(collectionIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        for (IValue value : this) {
            if (collection.contains(value)) continue;
            this.remove(value);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object value : collection) {
            changed |= this.remove(value);
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        Object[] values = new Object[this.load];
        Iterator<IValue> valuesIterator = this.iterator();
        int i = 0;
        while (valuesIterator.hasNext()) {
            values[i++] = valuesIterator.next();
        }
        return values;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.load) {
            return this.toArray();
        }
        Iterator<IValue> valuesIterator = this.iterator();
        int i = 0;
        while (valuesIterator.hasNext()) {
            array[i++] = valuesIterator.next();
        }
        while (i < this.load) {
            array[i] = null;
            ++i;
        }
        return array;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < this.data.length; ++i) {
            buffer.append('[');
            Entry<IValue> e = this.data[i];
            if (e != null) {
                buffer.append(e);
                e = e.next;
                while (e != null) {
                    buffer.append(',');
                    buffer.append(e);
                    e = e.next;
                }
            }
            buffer.append(']');
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return this.currentHashCode;
    }

    public boolean isEqual(ShareableValuesHashSet other) {
        if (other == null) {
            return false;
        }
        if (other.currentHashCode != this.currentHashCode) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        Iterator<IValue> otherIterator = other.iterator();
        while (otherIterator.hasNext()) {
            if (this.contains(otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean containsTruelyEqual(IValue value) {
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && ((Object)value).equals(entry.value)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            ShareableValuesHashSet other = (ShareableValuesHashSet)o;
            if (other.currentHashCode != this.currentHashCode) {
                return false;
            }
            if (other.size() != this.size()) {
                return false;
            }
            if (this.isEmpty()) {
                return true;
            }
            Iterator<IValue> otherIterator = other.iterator();
            while (otherIterator.hasNext()) {
                if (this.containsTruelyEqual(otherIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetIterator
    implements Iterator<IValue> {
        private final Entry<IValue>[] data;
        private Entry<IValue> current;
        private int index;

        public SetIterator(ShareableValuesHashSet shareableValuesHashSet) {
            this.data = shareableValuesHashSet.data;
            this.index = this.data.length - 1;
            this.current = new Entry<IValue>(0, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<IValue> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public IValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more elements in this iteration");
            }
            IValue value = (IValue)this.current.value;
            this.locateNext();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        public final int hash;
        public final V value;
        public final Entry<V> next;

        public Entry(int hash, V value, Entry<V> next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            buffer.append(this.value);
            buffer.append('>');
            return buffer.toString();
        }
    }
}

